/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAnyElementAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceXmlAnyElementAnnotation
extends SourceAnnotation
implements XmlAnyElementAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlAnyElement");
    private final DeclarationAnnotationElementAdapter<Boolean> laxDeclarationAdapter;
    private final AnnotationElementAdapter<Boolean> laxAdapter;
    private Boolean lax;
    private TextRange laxTextRange;
    private final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter;
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;
    private TextRange valueTextRange;
    private String fullyQualifiedValueClassName;

    public SourceXmlAnyElementAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
        this(parent, annotatedElement, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new ElementAnnotationAdapter(annotatedElement, DECLARATION_ANNOTATION_ADAPTER));
    }

    public SourceXmlAnyElementAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super((JavaResourceModel)parent, annotatedElement, daa, annotationAdapter);
        this.laxDeclarationAdapter = this.buildLaxAdapter(daa);
        this.laxAdapter = this.buildShortCircuitBooleanElementAdapter(this.laxDeclarationAdapter);
        this.valueDeclarationAdapter = this.buildValueAdapter(daa);
        this.valueAdapter = this.buildAnnotationElementAdapter(this.valueDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildLaxAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"lax");
    }

    private DeclarationAnnotationElementAdapter<String> buildValueAdapter(DeclarationAnnotationAdapter daa) {
        return this.buildAnnotationElementAdapter(daa, "value", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    private DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private AnnotationElementAdapter<Boolean> buildShortCircuitBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlAnyElement";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.lax = this.buildLax(astAnnotation);
        this.laxTextRange = this.buildLaxTextRange(astAnnotation);
        this.value = this.buildValue(astAnnotation);
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
        this.fullyQualifiedValueClassName = this.buildFullyQualifiedValueClassName(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncLax(this.buildLax(astAnnotation));
        this.laxTextRange = this.buildLaxTextRange(astAnnotation);
        this.syncValue(this.buildValue(astAnnotation));
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
        this.syncFullyQualifiedValueClassName(this.buildFullyQualifiedValueClassName(astAnnotation));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public Boolean getLax() {
        return this.lax;
    }

    @Override
    public void setLax(Boolean lax) {
        if (this.attributeValueHasChanged(this.lax, lax)) {
            this.lax = lax;
            this.laxAdapter.setValue((Object)lax);
        }
    }

    private void syncLax(Boolean astLax) {
        Boolean old = this.lax;
        this.lax = astLax;
        this.firePropertyChanged("lax", old, astLax);
    }

    private Boolean buildLax(Annotation astAnnotation) {
        return (Boolean)this.laxAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getLaxTextRange() {
        return this.laxTextRange;
    }

    private TextRange buildLaxTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.laxDeclarationAdapter, astAnnotation);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(Annotation astAnnotation) {
        return (String)this.valueAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getValueTextRange() {
        return this.valueTextRange;
    }

    private TextRange buildValueTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astAnnotation);
    }

    @Override
    public String getFullyQualifiedValueClassName() {
        return this.fullyQualifiedValueClassName;
    }

    private void syncFullyQualifiedValueClassName(String name) {
        String old = this.fullyQualifiedValueClassName;
        this.fullyQualifiedValueClassName = name;
        this.firePropertyChanged("fullyQualifiedValueClassName", old, name);
    }

    private String buildFullyQualifiedValueClassName(Annotation astAnnotation) {
        return this.value == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.valueAdapter.getExpression(astAnnotation));
    }
}

