/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.sdk.core;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.sdk.core.ISDKConstants;
import com.liferay.ide.sdk.core.SDKCorePlugin;
import com.liferay.ide.sdk.core.SDKHelper;
import com.liferay.ide.sdk.core.SDKUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.internal.core.XMLMemento;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDK {
    private static final String ALWAYS = "always";
    private static final String MSG_MANAGED_BY_LIFERAY_IDE = "Managed by Liferay IDE (remove this comment to prevent future updates)";
    private static final String PROJECT_FILE_PATTERN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>{0}</name>\n\t<comment></comment>\n\t<projects></projects>\n\t<buildSpec></buildSpec>\n\t<natures></natures>\n</projectDescription>\n";
    protected boolean contributed;
    protected boolean defaultSDK;
    protected IPath location;
    protected String name;
    protected String version;

    public static String createXMLNameValuePair(String name, String value) {
        return String.valueOf(name) + "=\"" + value + "\" ";
    }

    protected static IEclipsePreferences getPrefStore() {
        return new InstanceScope().getNode("com.liferay.ide.eclipse.sdk");
    }

    public SDK() {
    }

    public SDK(IPath location) {
        this.location = location;
    }

    public void addProjectFile() {
        File projectFile;
        if (this.hasProjectFile()) {
            return;
        }
        if (this.location.toFile().exists() && !(projectFile = this.location.append(".project").toFile()).exists()) {
            try {
                FileUtil.writeFileFromStream((File)projectFile, (InputStream)new ByteArrayInputStream(MessageFormat.format(PROJECT_FILE_PATTERN, this.name).getBytes("UTF-8")));
            }
            catch (Exception e) {
                SDKCorePlugin.logError(e);
            }
        }
    }

    public IStatus buildLanguage(IProject project, IFile langFile, Map<String, String> overrideProperties, Map<String, String> appServerProperties, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            String langDirLocation = langFile.getParent().getRawLocation().toOSString();
            String langFileName = langFile.getFullPath().removeFileExtension().lastSegment();
            properties.put("lang.dir", langDirLocation);
            properties.put("lang.file", langFileName);
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "build-lang-cmd", properties, true, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public IStatus buildService(IProject project, IFile serviceXmlFile, Map<String, String> overrideProperties, Map<String, String> appServerProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            String serviceFile = serviceXmlFile.getRawLocation().toOSString();
            properties.put("service.file", serviceXmlFile.getRawLocation().toOSString());
            properties.put("service.input.file", serviceFile);
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "build-service", properties, true, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public IStatus buildWSDD(IProject project, IFile serviceXmlFile, Map<String, String> overrideProperties, Map<String, String> appServerProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            String serviceFile = serviceXmlFile.getRawLocation().toOSString();
            properties.put("service.file", serviceXmlFile.getRawLocation().toOSString());
            properties.put("service.input.file", serviceFile);
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "build-wsdd", properties, true, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public IStatus cleanAppServer(IProject project, IPath bundleZipLocation, String appServerDir, Map<String, String> appServerProperties, IProgressMonitor monitor) {
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            IPath workPath = new Path(appServerDir).removeLastSegments(2);
            properties.put("app.server.zip.name", bundleZipLocation.toOSString());
            properties.put("ext.work.dir", workPath.toOSString());
            IStatus status = this.runTarget(project, properties, "clean-app-server", true, monitor);
            if (!status.isOK()) {
                return status;
            }
        }
        catch (Exception ex) {
            return SDKCorePlugin.createErrorStatus(ex);
        }
        return Status.OK_STATUS;
    }

    public IStatus compileThemePlugin(IProject project, Map<String, String> overrideProperties, Map<String, String> appServerProperties) {
        SDKHelper antHelper = new SDKHelper(this);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "compile", properties, true, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public SDK copy() {
        SDK copy = new SDK(this.getLocation());
        copy.setContributed(this.isContributed());
        copy.setDefault(this.isDefault());
        copy.setName(this.getName());
        copy.setVersion(this.getVersion());
        return copy;
    }

    public IPath createNewExtProject(String extName, String extDisplayName, Map<String, String> appServerProperties, boolean separateJRE, String workingDir, String baseDir, IProgressMonitor monitor) {
        try {
            SDKHelper antHelper = new SDKHelper(this, monitor);
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(appServerProperties);
            properties.put("ext.name", extName);
            properties.put("ext.display.name", extDisplayName);
            IPath tempPath = SDKCorePlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("ext.parent.dir", tempPath.toOSString());
            if (baseDir != null) {
                properties.put("plugin.type.dir", baseDir);
            }
            antHelper.runTarget(this.getLocation().append(ISDKConstants.EXT_PLUGIN_ANT_BUILD), "create", properties, separateJRE, workingDir);
            return tempPath;
        }
        catch (Exception e) {
            SDKCorePlugin.logError(e);
            return null;
        }
    }

    public IPath createNewHookProject(String hookName, String hookDisplayName, boolean separateJRE, String workingDir, String baseDir, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("hook.name", hookName);
            properties.put("hook.display.name", hookDisplayName);
            IPath newHookPath = SDKCorePlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("hook.parent.dir", newHookPath.toOSString());
            IPath buildLocation = this.getLocation().append(ISDKConstants.HOOK_PLUGIN_ANT_BUILD);
            if (baseDir != null) {
                properties.put("plugin.type.dir", baseDir);
            }
            antHelper.runTarget(buildLocation, "create", properties, separateJRE, workingDir);
            return newHookPath;
        }
        catch (CoreException e) {
            SDKCorePlugin.logError((Exception)((Object)e));
            return null;
        }
    }

    public IPath createNewLayoutTplProject(String layoutTplName, String layoutTplDisplayName, Map<String, String> appServerProperties, boolean separateJRE, String workingDir, String baseDir, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(appServerProperties);
            properties.put("layouttpl.name", layoutTplName);
            properties.put("layouttpl.display.name", layoutTplDisplayName);
            IPath newLayoutTplPath = SDKCorePlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("layouttpl.parent.dir", newLayoutTplPath.toOSString());
            if (baseDir != null) {
                properties.put("plugin.type.dir", baseDir);
            }
            antHelper.runTarget(this.getLocation().append(ISDKConstants.LAYOUTTPL_PLUGIN_ANT_BUILD), "create", properties, separateJRE, workingDir);
            return newLayoutTplPath;
        }
        catch (Exception e) {
            SDKCorePlugin.logError(e);
            return null;
        }
    }

    public IPath createNewPortletProject(String portletName, String portletDisplayName, String portletFramework, Map<String, String> appServerProperties, boolean separateJRE, String workingDir, String baseDir, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("portlet.name", portletName);
            properties.put("portlet.display.name", portletDisplayName);
            properties.put("portlet.framework", portletFramework);
            IPath newPortletPath = SDKCorePlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("portlet.parent.dir", newPortletPath.toOSString());
            if (baseDir != null) {
                properties.put("plugin.type.dir", baseDir);
            }
            antHelper.runTarget(this.getLocation().append(ISDKConstants.PORTLET_PLUGIN_ANT_BUILD), "create", properties, separateJRE, workingDir);
            return newPortletPath;
        }
        catch (Exception e) {
            SDKCorePlugin.logError(e);
            return null;
        }
    }

    public IPath createNewThemeProject(String themeName, String themeDisplayName, boolean separateJRE, String workingDir, String baseDir, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("theme.name", themeName);
            properties.put("theme.display.name", themeDisplayName);
            IPath tempPath = SDKCorePlugin.getDefault().getStateLocation().append("create").append(String.valueOf(System.currentTimeMillis()));
            properties.put("theme.parent.dir", tempPath.toOSString());
            if (baseDir != null) {
                properties.put("plugin.type.dir", baseDir);
            }
            antHelper.runTarget(this.getLocation().append(ISDKConstants.THEME_PLUGIN_ANT_BUILD), "create", properties, separateJRE, workingDir);
            return tempPath;
        }
        catch (CoreException e) {
            SDKCorePlugin.logError((Exception)((Object)e));
            return null;
        }
    }

    public IStatus directDeploy(IProject project, Map<String, String> overrideProperties, boolean separateJRE, Map<String, String> appServerProperties, IProgressMonitor monitor) {
        try {
            SDKHelper antHelper = new SDKHelper(this, monitor);
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "direct-deploy", properties, separateJRE, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public IPath[] getAntLibraries() {
        ArrayList<IPath> antLibs = new ArrayList<IPath>();
        String[] stringArray = ISDKConstants.ANT_LIBRARIES;
        int n = ISDKConstants.ANT_LIBRARIES.length;
        int n2 = 0;
        while (n2 < n) {
            String antLib = stringArray[n2];
            antLibs.add(this.getLocation().append(antLib));
            ++n2;
        }
        return antLibs.toArray(new IPath[0]);
    }

    private String getDefaultWorkingDir(IPath buildFile) {
        return buildFile.removeLastSegments(1).toOSString();
    }

    public IPath getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public IPath getPortletTemplatePath() {
        return this.getLocation().append(ISDKConstants.PORTLET_PLUGIN_ZIP_PATH);
    }

    public String getVersion() {
        IPath sdkLocation;
        if (this.version == null && !(sdkLocation = this.getLocation().makeAbsolute()).isEmpty()) {
            try {
                Properties buildProperties;
                this.version = SDKUtil.readSDKVersion(sdkLocation.toOSString());
                if (this.version.equals(ILiferayConstants.V611.toString()) && this.hasAppServerSpecificProps(buildProperties = this.getProperties(sdkLocation.append("build.properties").toFile()))) {
                    this.version = ILiferayConstants.V612.toString();
                }
                if (this.version.equals(ILiferayConstants.V6120.toString()) && this.hasAppServerSpecificProps(buildProperties = this.getProperties(sdkLocation.append("build.properties").toFile()))) {
                    this.version = ILiferayConstants.V6130.toString();
                }
            }
            catch (Exception e) {
                SDKCorePlugin.logError("Could not detect the sdk version.", e);
            }
        }
        return this.version;
    }

    private boolean hasAppServerSpecificProps(Properties props) {
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            if (!name.matches("app.server.tomcat.*")) continue;
            return true;
        }
        return false;
    }

    private Properties getProperties(File file) {
        Properties properties = new Properties();
        try {
            FileInputStream propertiesInput = new FileInputStream(file);
            properties.load(propertiesInput);
            ((InputStream)propertiesInput).close();
        }
        catch (Exception e) {
            SDKCorePlugin.logError(e);
        }
        return properties;
    }

    public boolean hasProjectFile() {
        return this.location != null && this.location.append(".project").toFile().exists();
    }

    public boolean isContributed() {
        return this.contributed;
    }

    public boolean isDefault() {
        return this.defaultSDK;
    }

    public boolean isValid() {
        IPath sdkLocation = this.getLocation();
        if (sdkLocation == null) {
            return false;
        }
        if (!SDKUtil.isSDKSupported(sdkLocation.toOSString())) {
            return false;
        }
        return SDKUtil.isValidSDKLocation(sdkLocation.toOSString());
    }

    public void loadFromMemento(XMLMemento sdkElement) {
        this.setName(sdkElement.getString("name"));
        this.setLocation(Path.fromPortableString((String)sdkElement.getString("location")));
    }

    protected void persistAppServerProperties(Map<String, String> properties) throws FileNotFoundException, IOException, ConfigurationException {
        String userName;
        IPath loc = this.getLocation();
        File userBuildFile = loc.append("build." + (userName = System.getProperty("user.name")) + ".properties").toFile();
        if (userBuildFile.exists()) {
            String overwrite;
            PropertiesConfiguration propsConfig = new PropertiesConfiguration(userBuildFile);
            String header = propsConfig.getHeader();
            boolean shouldUpdateBuildFile = false;
            shouldUpdateBuildFile = header != null && header.contains(MSG_MANAGED_BY_LIFERAY_IDE) ? true : ALWAYS.equals(overwrite = SDK.getPrefStore().get("OVERWRITE_USER_BUILD_FILE", ALWAYS));
            if (shouldUpdateBuildFile) {
                for (String key : properties.keySet()) {
                    propsConfig.setProperty(key, (Object)properties.get(key));
                }
                propsConfig.setHeader(MSG_MANAGED_BY_LIFERAY_IDE);
                propsConfig.save(userBuildFile);
            }
        } else {
            Properties props = new Properties();
            props.putAll(properties);
            props.store(new FileOutputStream(userBuildFile), MSG_MANAGED_BY_LIFERAY_IDE);
        }
    }

    public IStatus runCommand(IProject project, IFile buildXmlFile, String command, Map<String, String> overrideProperties, Map<String, String> appServerProperties, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            IPath buildFile = buildXmlFile.getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, command, properties, true, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    protected IStatus runTarget(IProject project, Map<String, String> properties, String target, boolean separateJRE, IProgressMonitor monitor) {
        SDKHelper antHelper = new SDKHelper(this, monitor);
        try {
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, target, properties, separateJRE, workingDir);
        }
        catch (CoreException e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    public void saveToMemento(XMLMemento child) {
        child.putString("name", this.getName());
        child.putString("location", this.getLocation().toPortableString());
        child.putString("version", this.getVersion());
    }

    public void setContributed(boolean contributed) {
        this.contributed = contributed;
    }

    public void setDefault(boolean defaultSDK) {
        this.defaultSDK = defaultSDK;
    }

    public void setLocation(IPath location) {
        this.location = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return String.valueOf(this.getName()) + (this.isDefault() ? " [default]" : "");
    }

    public String toXmlString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<sdk ");
        builder.append(SDK.createXMLNameValuePair("name", this.getName()));
        builder.append(SDK.createXMLNameValuePair("location", this.getLocation().toPortableString()));
        builder.append(SDK.createXMLNameValuePair("version", this.getVersion()));
        builder.append("/>");
        return builder.toString();
    }

    public IStatus validate() {
        boolean validLocation = SDKUtil.isValidSDKLocation(this.getLocation().toOSString());
        boolean buildXmlExists = this.getLocation().append("build.xml").toFile().exists();
        if (!validLocation) {
            return SDKCorePlugin.createErrorStatus(Msgs.SDKLocationInvalid);
        }
        if (!buildXmlExists) {
            return SDKCorePlugin.createErrorStatus(Msgs.buildXmlFileNotExist);
        }
        return Status.OK_STATUS;
    }

    public IStatus war(IProject project, Map<String, String> overrideProperties, boolean separateJRE, Map<String, String> appServerProperties, IProgressMonitor monitor) {
        return this.war(project, overrideProperties, separateJRE, appServerProperties, null, monitor);
    }

    public IStatus war(IProject project, Map<String, String> overrideProperties, boolean separateJRE, Map<String, String> appServerProperties, String[] vmargs, IProgressMonitor monitor) {
        try {
            SDKHelper antHelper = new SDKHelper(this, monitor);
            antHelper.setVMArgs(vmargs);
            this.persistAppServerProperties(appServerProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (overrideProperties != null) {
                properties.putAll(overrideProperties);
            }
            IPath buildFile = project.getFile(ISDKConstants.PROJECT_BUILD_XML).getRawLocation();
            String workingDir = this.getDefaultWorkingDir(buildFile);
            antHelper.runTarget(buildFile, "war", properties, separateJRE, workingDir);
        }
        catch (Exception e) {
            return SDKCorePlugin.createErrorStatus(e);
        }
        return Status.OK_STATUS;
    }

    private static class Msgs
    extends NLS {
        public static String buildXmlFileNotExist;
        public static String SDKLocationInvalid;

        static {
            Msgs.initializeMessages((String)SDK.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

