/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.dd;

import com.liferay.ide.core.util.DescriptorHelper;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.portlet.core.operation.INewPortletClassDataModelProperties;
import com.liferay.ide.project.core.util.LiferayDescriptorHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PortletDescriptorHelper
extends LiferayDescriptorHelper
implements INewPortletClassDataModelProperties {
    public PortletDescriptorHelper(IProject project) {
        super(project);
    }

    public IStatus addNewPortlet(final IDataModel model) {
        IFile descriptorFile = this.getDescriptorFile("portlet.xml");
        DescriptorHelper.DOMModelEditOperation domModelOperation = new DescriptorHelper.DOMModelEditOperation((DescriptorHelper)this, descriptorFile){

            protected void createDefaultFile() {
                String templateString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<portlet-app xmlns=\"http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd\" version=\"2.0\">\n</portlet-app>";
                this.createDefaultDescriptor(templateString, "");
            }

            protected IStatus doExecute(IDOMDocument document) {
                return PortletDescriptorHelper.this.updatePortletXML(document, model);
            }
        };
        IStatus status = domModelOperation.execute();
        if (!status.isOK()) {
            return status;
        }
        domModelOperation = new DescriptorHelper.DOMModelEditOperation((DescriptorHelper)this, this.getDescriptorFile("liferay-portlet.xml")){

            protected void createDefaultFile() {
                String templateString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE liferay-portlet-app PUBLIC \"-//Liferay//DTD Portlet Application {0}//EN\" \"http://www.liferay.com/dtd/liferay-portlet-app_{1}.dtd\">\n\n<liferay-portlet-app>\n\t<role-mapper>\n\t\t<role-name>administrator</role-name>\n\t\t<role-link>Administrator</role-link>\n\t</role-mapper>\n\t<role-mapper>\n\t\t<role-name>guest</role-name>\n\t\t<role-link>Guest</role-link>\n\t</role-mapper>\n\t<role-mapper>\n\t\t<role-name>power-user</role-name>\n\t\t<role-link>Power User</role-link>\n\t</role-mapper>\n\t<role-mapper>\n\t\t<role-name>user</role-name>\n\t\t<role-link>User</role-link>\n\t</role-mapper>\n</liferay-portlet-app>";
                this.createDefaultDescriptor(templateString, PortletDescriptorHelper.this.getDescriptorVersion());
            }

            protected IStatus doExecute(IDOMDocument document) {
                return PortletDescriptorHelper.this.updateLiferayPortletXML(document, model);
            }
        };
        status = domModelOperation.execute();
        if (!status.isOK()) {
            return status;
        }
        domModelOperation = new DescriptorHelper.DOMModelEditOperation((DescriptorHelper)this, this.getDescriptorFile("liferay-display.xml")){

            protected void createDefaultFile() {
                String templateString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE display PUBLIC \"-//Liferay//DTD Display {0}//EN\" \"http://www.liferay.com/dtd/liferay-display_{1}.dtd\">\n\n<display>\n</display>";
                this.createDefaultDescriptor(templateString, PortletDescriptorHelper.this.getDescriptorVersion());
            }

            protected IStatus doExecute(IDOMDocument document) {
                return PortletDescriptorHelper.this.updateLiferayDisplayXML(document, model);
            }
        };
        status = domModelOperation.execute();
        return status;
    }

    public String[] getAllPortletCategories() {
        final ArrayList allPortletCategories = new ArrayList();
        IFile descriptorFile = this.getDescriptorFile("liferay-display.xml");
        if (descriptorFile != null) {
            DescriptorHelper.DOMModelReadOperation op = new DescriptorHelper.DOMModelReadOperation((DescriptorHelper)this, descriptorFile){

                protected IStatus doExecute(IDOMDocument document) {
                    NodeList nodeList = document.getElementsByTagName("category");
                    if (nodeList != null && nodeList.getLength() > 0) {
                        int i = 0;
                        while (i < nodeList.getLength()) {
                            Element categoryElemnt = (Element)nodeList.item(i);
                            String categoryName = categoryElemnt.getAttribute("name");
                            if (categoryName != null && !categoryName.matches("\\s*")) {
                                allPortletCategories.add(categoryName);
                            }
                            ++i;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            op.execute();
        }
        return allPortletCategories.toArray(new String[0]);
    }

    public String[] getAllPortletNames() {
        final ArrayList allPortletNames = new ArrayList();
        IFile descriptorFile = this.getDescriptorFile("portlet.xml");
        if (descriptorFile != null) {
            DescriptorHelper.DOMModelReadOperation op = new DescriptorHelper.DOMModelReadOperation((DescriptorHelper)this, descriptorFile){

                protected IStatus doExecute(IDOMDocument document) {
                    NodeList nodeList = document.getElementsByTagName("portlet-name");
                    int i = 0;
                    while (i < nodeList.getLength()) {
                        Element portletName = (Element)nodeList.item(i);
                        allPortletNames.add(NodeUtil.getTextContent((Node)portletName));
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            op.execute();
        }
        return allPortletNames.toArray(new String[0]);
    }

    protected String getPortletClassText(IDataModel model) {
        return model.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
    }

    protected IStatus removeAllElements(IDOMDocument document, String tagName) {
        if (document == null) {
            return PortletCore.createErrorStatus(MessageFormat.format("Could not remove {0} elements: null document", tagName));
        }
        NodeList elements = document.getElementsByTagName(tagName);
        try {
            if (elements != null && elements.getLength() > 0) {
                int i = 0;
                while (i < elements.getLength()) {
                    Node element = elements.item(i);
                    element.getParentNode().removeChild(element);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            return PortletCore.createErrorStatus(MessageFormat.format("Could not remove {0} elements", tagName), ex);
        }
        return Status.OK_STATUS;
    }

    public IStatus removeAllPortlets() {
        IFile descriptorFile = this.getDescriptorFile("portlet.xml");
        DescriptorHelper.DOMModelEditOperation domModelOperation = new DescriptorHelper.DOMModelEditOperation((DescriptorHelper)this, descriptorFile){

            protected void createDefaultFile() {
            }

            protected IStatus doExecute(IDOMDocument document) {
                return PortletDescriptorHelper.this.removeAllElements(document, "portlet");
            }
        };
        IStatus status = domModelOperation.execute();
        if (!status.isOK()) {
            return status;
        }
        domModelOperation = new DescriptorHelper.DOMModelEditOperation((DescriptorHelper)this, this.getDescriptorFile("liferay-portlet.xml")){

            protected void createDefaultFile() {
            }

            protected IStatus doExecute(IDOMDocument document) {
                return PortletDescriptorHelper.this.removeAllElements(document, "portlet");
            }
        };
        status = domModelOperation.execute();
        if (!status.isOK()) {
            return status;
        }
        domModelOperation = new DescriptorHelper.DOMModelEditOperation((DescriptorHelper)this, this.getDescriptorFile("liferay-display.xml")){

            protected void createDefaultFile() {
            }

            protected IStatus doExecute(IDOMDocument document) {
                return PortletDescriptorHelper.this.removeAllElements(document, "category");
            }
        };
        status = domModelOperation.execute();
        return status;
    }

    public IStatus updateLiferayDisplayXML(IDOMDocument document, IDataModel model) {
        Element rootElement = document.getDocumentElement();
        Element category = null;
        String modelCategory = model.getStringProperty("INewPortletClassDataModelProperties.CATEGORY");
        for (Element child : this.getChildElements(rootElement)) {
            if (!child.getNodeName().equals("category") || !modelCategory.equals(child.getAttribute("name"))) continue;
            category = child;
            break;
        }
        Element id = null;
        String modelId = model.getStringProperty("INewPortletClassDataModelProperties.ID");
        if (category != null) {
            for (Element child : this.getChildElements(category)) {
                if (!child.getNodeName().equals("portlet") || !modelId.equals(child.getAttribute("id"))) continue;
                id = child;
                break;
            }
        } else {
            category = document.createElement("category");
            category.setAttribute("name", modelCategory);
            rootElement.appendChild(category);
            Text newline = document.createTextNode(System.getProperty("line.separator"));
            rootElement.appendChild(newline);
        }
        if (id == null) {
            NodeUtil.appendChildElement((Element)category, (String)"portlet").setAttribute("id", modelId);
        }
        FormatProcessorXML processor = new FormatProcessorXML();
        processor.formatNode((Node)category);
        return Status.OK_STATUS;
    }

    public IStatus updateLiferayPortletXML(IDOMDocument document, IDataModel model) {
        Element rootElement = document.getDocumentElement();
        Element newPortletElement = document.createElement("portlet");
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"portlet-name", (String)model.getStringProperty("INewPortletClassDataModelProperties.LIFERAY_PORTLET_NAME"));
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"icon", (String)model.getStringProperty("INewPortletClassDataModelProperties.ICON_FILE"));
        if (model.getBooleanProperty("INewPortletClassDataModelProperties.ADD_TO_CONTROL_PANEL")) {
            String entryCategory = model.getStringProperty("INewPortletClassDataModelProperties.ENTRY_CATEGORY").replaceAll("^category\\.", "");
            NodeUtil.appendChildElement((Element)newPortletElement, (String)"control-panel-entry-category", (String)entryCategory);
            NodeUtil.appendChildElement((Element)newPortletElement, (String)"control-panel-entry-weight", (String)model.getStringProperty("INewPortletClassDataModelProperties.ENTRY_WEIGHT"));
            if (model.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_ENTRY_CLASS")) {
                NodeUtil.appendChildElement((Element)newPortletElement, (String)"control-panel-entry-class", (String)(String.valueOf(model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE")) + "." + model.getStringProperty("INewPortletClassDataModelProperties.ENTRY_CLASS_NAME")));
            }
        }
        if (model.getBooleanProperty("INewPortletClassDataModelProperties.ALLOW_MULTIPLE")) {
            NodeUtil.appendChildElement((Element)newPortletElement, (String)"instanceable", (String)Boolean.toString(model.getBooleanProperty("INewPortletClassDataModelProperties.ALLOW_MULTIPLE")));
        }
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"header-portlet-css", (String)model.getStringProperty("INewPortletClassDataModelProperties.CSS_FILE"));
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"footer-portlet-javascript", (String)model.getStringProperty("INewPortletClassDataModelProperties.JAVASCRIPT_FILE"));
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"css-class-wrapper", (String)model.getStringProperty("INewPortletClassDataModelProperties.CSS_CLASS_WRAPPER"));
        Element firstRoleMapper = null;
        for (Element child : this.getChildElements(rootElement)) {
            if (!child.getNodeName().equals("role-mapper")) continue;
            firstRoleMapper = child;
            break;
        }
        Text newline = document.createTextNode(System.getProperty("line.separator"));
        if (firstRoleMapper != null) {
            rootElement.insertBefore(newPortletElement, firstRoleMapper);
            rootElement.insertBefore(newline, firstRoleMapper);
        } else {
            rootElement.appendChild(newPortletElement);
            rootElement.appendChild(newline);
        }
        FormatProcessorXML processor = new FormatProcessorXML();
        processor.formatNode((Node)newPortletElement);
        return Status.OK_STATUS;
    }

    public IStatus updatePortletXML(IDOMDocument document, IDataModel model) {
        Element rootElement = document.getDocumentElement();
        Element newPortletElement = document.createElement("portlet");
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"portlet-name", (String)model.getStringProperty("INewPortletClassDataModelProperties.PORTLET_NAME"));
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"display-name", (String)model.getStringProperty("INewPortletClassDataModelProperties.DISPLAY_NAME"));
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"portlet-class", (String)this.getPortletClassText(model));
        List initParams = (List)model.getProperty("INewPortletClassDataModelProperties.INIT_PARAMS");
        for (ParamValue initParam : initParams) {
            Element newInitParamElement = NodeUtil.appendChildElement((Element)newPortletElement, (String)"init-param");
            NodeUtil.appendChildElement((Element)newInitParamElement, (String)"name", (String)initParam.getName());
            NodeUtil.appendChildElement((Element)newInitParamElement, (String)"value", (String)initParam.getValue());
        }
        NodeUtil.appendChildElement((Element)newPortletElement, (String)"expiration-cache", (String)"0");
        Element newSupportsElement = NodeUtil.appendChildElement((Element)newPortletElement, (String)"supports");
        NodeUtil.appendChildElement((Element)newSupportsElement, (String)"mime-type", (String)"text/html");
        String[] stringArray = ALL_PORTLET_MODES;
        int n = ALL_PORTLET_MODES.length;
        int newInitParamElement = 0;
        while (newInitParamElement < n) {
            String portletMode = stringArray[newInitParamElement];
            if (model.getBooleanProperty(portletMode)) {
                NodeUtil.appendChildElement((Element)newSupportsElement, (String)"portlet-mode", (String)model.getPropertyDescriptor(portletMode).getPropertyDescription());
            }
            ++newInitParamElement;
        }
        if (model.getBooleanProperty("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE")) {
            String bundlePath = model.getStringProperty("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE_PATH");
            String bundleValue = bundlePath.replaceAll("\\.properties$", "");
            NodeUtil.appendChildElement((Element)newPortletElement, (String)"resource-bundle", (String)bundleValue);
        }
        Element newPortletInfoElement = NodeUtil.appendChildElement((Element)newPortletElement, (String)"portlet-info");
        NodeUtil.appendChildElement((Element)newPortletInfoElement, (String)"title", (String)model.getStringProperty("INewPortletClassDataModelProperties.TITLE"));
        NodeUtil.appendChildElement((Element)newPortletInfoElement, (String)"short-title", (String)model.getStringProperty("INewPortletClassDataModelProperties.SHORT_TITLE"));
        NodeUtil.appendChildElement((Element)newPortletInfoElement, (String)"keywords", (String)model.getStringProperty("INewPortletClassDataModelProperties.KEYWORDS"));
        String[] stringArray2 = DEFAULT_SECURITY_ROLE_NAMES;
        int n2 = DEFAULT_SECURITY_ROLE_NAMES.length;
        n = 0;
        while (n < n2) {
            String roleName = stringArray2[n];
            NodeUtil.appendChildElement((Element)NodeUtil.appendChildElement((Element)newPortletElement, (String)"security-role-ref"), (String)"role-name", (String)roleName);
            ++n;
        }
        Node refNode = null;
        String[] refElementNames = new String[]{"custom-portlet-mode", "custom-window-state", "user-attribute", "security-constraint", "resource-bundle", "filter", "filter-mapping", "default-namespace", "event-definition", "public-render-parameter", "listener", "container-runtime-option"};
        int i = 0;
        while (i < refElementNames.length) {
            refNode = NodeUtil.findFirstChild((Element)rootElement, (String)refElementNames[i]);
            if (refNode != null) break;
            ++i;
        }
        rootElement.insertBefore(newPortletElement, refNode);
        rootElement.appendChild(document.createTextNode(System.getProperty("line.separator")));
        FormatProcessorXML processor = new FormatProcessorXML();
        processor.formatNode((Node)newPortletElement);
        return Status.OK_STATUS;
    }
}

