/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.cmd;

import com.liferay.ide.layouttpl.ui.model.LayoutConstraint;
import com.liferay.ide.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.layouttpl.ui.model.PortletLayout;
import com.liferay.ide.layouttpl.ui.util.LayoutTplUIUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.osgi.util.NLS;

public class PortletColumnChangeConstraintCommand
extends Command {
    protected PortletColumn column;
    protected PortletLayout currentParent;
    protected int diffWeight = 0;
    protected PortletLayout newParent;
    protected LayoutConstraint layoutConstraint;

    public PortletColumnChangeConstraintCommand(PortletColumn column, PortletLayout currentParent, PortletLayout newParent, LayoutConstraint constraint) {
        this.column = column;
        this.currentParent = currentParent;
        this.newParent = newParent;
        this.layoutConstraint = constraint;
        this.setLabel(Msgs.portletColumnChanged);
    }

    public boolean canExecute() {
        return this.column != null && this.currentParent != null && this.newParent != null && this.layoutConstraint != null && this.layoutConstraint.refColumn != null;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        if (((Object)((Object)this.currentParent)).equals((Object)this.newParent)) {
            int existingWeight = this.column.getWeight();
            this.column.setWeight(this.layoutConstraint.weight);
            this.diffWeight = existingWeight - this.layoutConstraint.weight;
            PortletColumn refColumn = this.layoutConstraint.refColumn;
            int newWeight = refColumn.getWeight() + this.diffWeight;
            if (refColumn.getWeight() == 33) {
                ++newWeight;
            }
            newWeight = LayoutTplUIUtil.adjustWeight(newWeight);
            refColumn.setWeight(newWeight);
        }
    }

    public void undo() {
        this.column.setWeight(this.column.getWeight() + this.diffWeight);
        PortletColumn refColumn = this.layoutConstraint.refColumn;
        int newWeight = refColumn.getWeight() - this.diffWeight;
        if (refColumn.getWeight() == 33) {
            ++newWeight;
        }
        newWeight = LayoutTplUIUtil.adjustWeight(newWeight);
        refColumn.setWeight(newWeight);
    }

    private static class Msgs
    extends NLS {
        public static String portletColumnChanged;

        static {
            Msgs.initializeMessages((String)PortletColumnChangeConstraintCommand.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

