/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.wizard;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.layouttpl.core.model.LayoutTplDiagramElement;
import com.liferay.ide.layouttpl.core.operation.INewLayoutTplDataModelProperties;
import com.liferay.ide.layouttpl.core.operation.LayoutTplDescriptorHelper;
import com.liferay.ide.layouttpl.core.util.LayoutTplUtil;
import com.liferay.ide.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.layouttpl.ui.model.LayoutTplDiagram;
import com.liferay.ide.layouttpl.ui.model.PortletColumn;
import com.liferay.ide.layouttpl.ui.model.PortletLayout;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.wizard.LiferayDataModelOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AddLayoutTplOperation
extends LiferayDataModelOperation
implements INewLayoutTplDataModelProperties {
    public AddLayoutTplOperation(IDataModel model, TemplateStore templateStore, TemplateContextType contextType) {
        super(model, templateStore, contextType);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus retval = null;
        IDataModel dm = this.getDataModel();
        LayoutTplDiagram diagramModel = this.createLayoutTplDigram(dm);
        try {
            String thumbnailFile;
            String templateFile = this.getDataModel().getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE");
            IFile templateFileValue = null;
            if (!CoreUtil.isNullOrEmpty((String)templateFile)) {
                templateFileValue = this.createTemplateFile(templateFile, diagramModel);
            }
            this.getDataModel().setProperty("INewLayoutTplModelProperties.LAYOUT_TPL_FILE_CREATED", (Object)templateFileValue);
            String wapTemplateFile = this.getDataModel().getStringProperty("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE");
            if (!CoreUtil.isNullOrEmpty((String)wapTemplateFile)) {
                this.createTemplateFile(wapTemplateFile, diagramModel);
            }
            if (!CoreUtil.isNullOrEmpty((String)(thumbnailFile = this.getDataModel().getStringProperty("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE")))) {
                this.createThumbnailFile(thumbnailFile, diagramModel);
            }
        }
        catch (CoreException ex) {
            LayoutTplUI.logError((Exception)((Object)ex));
            return LayoutTplUI.createErrorStatus((Exception)((Object)ex));
        }
        catch (IOException ex) {
            LayoutTplUI.logError(ex);
            return LayoutTplUI.createErrorStatus(ex);
        }
        LayoutTplDescriptorHelper layoutTplDescHelper = new LayoutTplDescriptorHelper(this.getTargetProject());
        retval = layoutTplDescHelper.addNewLayoutTemplate(dm);
        return retval;
    }

    protected void createThumbnailFile(String thumbnailFile, LayoutTplDiagram diagramModel) throws CoreException, IOException {
        IFolder defaultDocroot = CoreUtil.getDefaultDocrootFolder((IProject)this.getTargetProject());
        IFile thumbnailFileValue = defaultDocroot.getFile(thumbnailFile);
        URL iconFileURL = LayoutTplUI.getDefault().getBundle().getEntry("/icons/blank_columns.png");
        CoreUtil.prepareFolder((IFolder)((IFolder)thumbnailFileValue.getParent()));
        if (thumbnailFileValue.exists()) {
            thumbnailFileValue.setContents(iconFileURL.openStream(), 1, null);
        } else {
            thumbnailFileValue.create(iconFileURL.openStream(), true, null);
        }
    }

    protected IFile createTemplateFile(String templateFile, LayoutTplDiagram diagramModel) throws CoreException {
        IFolder defaultDocroot = CoreUtil.getDefaultDocrootFolder((IProject)this.getTargetProject());
        IFile templateFileValue = defaultDocroot.getFile(templateFile);
        CoreUtil.prepareFolder((IFolder)((IFolder)templateFileValue.getParent()));
        if (diagramModel != null) {
            LayoutTplUtil.saveToFile((LayoutTplDiagramElement)diagramModel, (IFile)templateFileValue, null);
        } else {
            ByteArrayInputStream input = new ByteArrayInputStream("".getBytes());
            if (templateFileValue.exists()) {
                templateFileValue.setContents((InputStream)input, 1, null);
            } else {
                templateFileValue.create((InputStream)input, true, null);
            }
        }
        return templateFileValue;
    }

    protected LayoutTplDiagram createLayoutTplDigram(IDataModel dm) {
        LayoutTplDiagram diagram = new LayoutTplDiagram();
        if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_BLANK_COLUMN")) {
            diagram = null;
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(100), 0);
            diagram.addRow(row);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_I_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(100), 0);
            PortletLayout row2 = new PortletLayout();
            row2.addColumn(new PortletColumn(70), 0);
            row2.addColumn(new PortletColumn(30), 0);
            diagram.addRow(row);
            diagram.addRow(row2);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_II_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(100), 0);
            PortletLayout row2 = new PortletLayout();
            row2.addColumn(new PortletColumn(30), 0);
            row2.addColumn(new PortletColumn(70), 0);
            diagram.addRow(row);
            diagram.addRow(row2);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_1_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(100), 0);
            PortletLayout row2 = new PortletLayout();
            row2.addColumn(new PortletColumn(50), 0);
            row2.addColumn(new PortletColumn(50), 0);
            PortletLayout row3 = new PortletLayout();
            row3.addColumn(new PortletColumn(100), 0);
            diagram.addRow(row);
            diagram.addRow(row2);
            diagram.addRow(row3);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_I_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(50), 0);
            row.addColumn(new PortletColumn(50), 0);
            diagram.addRow(row);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_II_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(70), 0);
            row.addColumn(new PortletColumn(30), 0);
            diagram.addRow(row);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_III_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(30), 0);
            row.addColumn(new PortletColumn(70), 0);
            diagram.addRow(row);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_2_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(30), 0);
            row.addColumn(new PortletColumn(70), 0);
            PortletLayout row2 = new PortletLayout();
            row2.addColumn(new PortletColumn(70), 0);
            row2.addColumn(new PortletColumn(30), 0);
            diagram.addRow(row);
            diagram.addRow(row2);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_3_COLUMN")) {
            PortletLayout row = new PortletLayout();
            row.addColumn(new PortletColumn(33), 0);
            row.addColumn(new PortletColumn(33), 0);
            row.addColumn(new PortletColumn(33), 0);
            diagram.addRow(row);
        }
        return diagram;
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtil.getProject((String)projectName);
    }
}

