/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeException
extends RuntimeException {
    private final Throwable[] exceptions;
    private static final long serialVersionUID = 1L;

    public CompositeException(Collection<Throwable> exceptions) {
        this(exceptions.toArray(new Throwable[exceptions.size()]));
    }

    public CompositeException(Throwable ... exceptions) {
        super(CompositeException.buildMessage(exceptions));
        this.exceptions = exceptions;
    }

    public Iterable<Throwable> getExceptions() {
        return IterableTools.iterable(this.exceptions);
    }

    private static String buildMessage(Throwable[] exceptions) {
        StringBuilder sb = new StringBuilder();
        sb.append(exceptions.length);
        sb.append(" exceptions");
        if (exceptions.length > 0) {
            sb.append(": [");
            Throwable[] throwableArray = exceptions;
            int n = exceptions.length;
            int n2 = 0;
            while (n2 < n) {
                Throwable ex = throwableArray[n2];
                sb.append(ex.getClass().getSimpleName());
                sb.append(", ");
                ++n2;
            }
            sb.setLength(sb.length() - 2);
            sb.append(']');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(this);
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                s.print("\tat ");
                s.println(element);
                ++n2;
            }
            int i = 1;
            Throwable[] throwableArray = this.exceptions;
            int n3 = this.exceptions.length;
            n = 0;
            while (n < n3) {
                Throwable ex = throwableArray[n];
                s.print("Nested exception ");
                s.print(i++);
                s.print(": ");
                ex.printStackTrace(s);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(this);
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                s.print("\tat ");
                s.println(element);
                ++n2;
            }
            int i = 1;
            Throwable[] throwableArray = this.exceptions;
            int n3 = this.exceptions.length;
            n = 0;
            while (n < n3) {
                Throwable ex = throwableArray[n];
                s.print("Nested exception ");
                s.print(i++);
                s.print(": ");
                ex.printStackTrace(s);
                ++n;
            }
        }
    }
}

