/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.transformer;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodTransformer<I, O>
implements Transformer<I, O>,
Serializable {
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private final Object[] arguments;
    private static final long serialVersionUID = 1L;

    public MethodTransformer(String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        if (methodName == null || parameterTypes == null || ArrayTools.contains(parameterTypes, null) || arguments == null) {
            throw new NullPointerException();
        }
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.arguments = arguments;
    }

    @Override
    public O transform(I input) {
        return (O)ObjectTools.execute(input, this.methodName, this.parameterTypes, this.arguments);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodTransformer)) {
            return false;
        }
        MethodTransformer other = (MethodTransformer)o;
        return ObjectTools.equals(this.methodName, other.methodName) && Arrays.equals(this.parameterTypes, other.parameterTypes) && Arrays.equals(this.arguments, other.arguments);
    }

    public int hashCode() {
        return this.methodName.hashCode() ^ Arrays.hashCode(this.parameterTypes) ^ Arrays.hashCode(this.arguments);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, ClassTools.buildMethodSignature(this.methodName, this.parameterTypes));
    }
}

