/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.common.ivysettings;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivyde.common.model.IvyFile;
import org.apache.ivyde.common.model.IvyModelSettings;

public class IvySettingsFile
extends IvyFile {
    private static final Pattern CLASSPATH_URL_PATTERN = Pattern.compile("<[\\s]*classpath[^>]+url=\"([^\"]+)");
    private static final Pattern CLASSPATH_FILE_PATTERN = Pattern.compile("<[\\s]*classpath[^>]+file=\"([^\"]+)");
    private static final Pattern TYPEDEF_PATTERN = Pattern.compile("<[\\s]*typedef[^>]+name=\"([^\"]+)\"[^>]+classname=\"([^\"]+)");
    private File file;
    static /* synthetic */ Class class$0;

    public IvySettingsFile(IvyModelSettings settings, File file, String projectName, String doc, int currentOffset) {
        super(settings, projectName, doc, currentOffset);
        this.file = file;
    }

    public URL[] getClasspathUrls() {
        ArrayList<URL> urls = new ArrayList<URL>();
        Matcher m = CLASSPATH_URL_PATTERN.matcher(this.getDoc());
        while (m.find()) {
            try {
                urls.add(new URL(this.substitute(m.group(1))));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        m = CLASSPATH_FILE_PATTERN.matcher(this.getDoc());
        while (m.find()) {
            try {
                urls.add(new URL(this.substitute(m.group(1))));
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    urls.add(new File(this.substitute(m.group(1))).toURI().toURL());
                }
                catch (MalformedURLException malformedURLException2) {}
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private String substitute(String str) {
        HashMap<String, String> variables = new HashMap<String, String>();
        if (this.file.getParentFile() != null) {
            URI settingsDirUri = this.file.getParentFile().toURI();
            variables.put("ivy.settings.dir", settingsDirUri.toString());
        }
        return IvyPatternHelper.substituteVariables((String)str, variables);
    }

    public Map getTypedefs() {
        Map p = IvySettingsFile.getDefaultTypedefs();
        Matcher m = TYPEDEF_PATTERN.matcher(this.getDoc());
        while (m.find()) {
            p.put(this.substitute(m.group(1)), this.substitute(m.group(2)));
        }
        return p;
    }

    public static Map getDefaultTypedefs() {
        Properties p = new Properties();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.ivy.core.settings.XmlSettingsParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            p.load(clazz.getResourceAsStream("typedef.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p;
    }
}

