/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.cp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class ResolvedPath {
    private String inputPath;
    private String resolvedPath;
    private File file;
    private URL url;
    private Exception e;

    public ResolvedPath(String inputPath, IProject project) {
        this.inputPath = inputPath;
        try {
            this.resolvePath(inputPath, project);
        }
        catch (MalformedURLException e) {
            this.e = e;
        }
        catch (CoreException e) {
            this.e = e;
        }
    }

    public boolean isSet() {
        return this.file != null || this.url != null;
    }

    public Exception getError() {
        return this.e;
    }

    public File getFile() {
        return this.file;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getResolvedPath() {
        return this.resolvedPath;
    }

    private void resolvePath(String inputPath, IProject project) throws CoreException, MalformedURLException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        this.resolvedPath = project != null ? inputPath.replaceAll("\\$\\{ivyproject_loc\\}", "\\${workspace_loc:" + project.getName() + "}") : inputPath;
        this.resolvedPath = manager.performStringSubstitution(this.resolvedPath, false);
        this.resolvedPath = this.resolvedPath.trim();
        if (this.resolvedPath.length() == 0) {
            return;
        }
        try {
            this.url = new URL(this.resolvedPath);
            if (this.url.getProtocol().equals("file")) {
                try {
                    this.file = new File(new URI(this.url.toString()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.file = new File(this.url.getPath());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.file = new File(this.url.getPath());
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.file = new File(this.resolvedPath);
            if (!this.file.isAbsolute()) {
                if (project != null) {
                    Path path = new Path(this.resolvedPath);
                    IFile ifile = project.getFile((IPath)path);
                    IPath ipath = ifile.getLocation();
                    this.file = ipath.toFile();
                } else {
                    this.file = this.file.getAbsoluteFile();
                }
            }
            this.url = this.file.toURI().toURL();
        }
    }
}

