/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivyde.eclipse.IvyDEException;
import org.apache.ivyde.eclipse.cp.ResolvedPath;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyMarkerManager;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.workspaceresolver.WorkspaceIvySettings;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public abstract class CachedIvy {
    private Ivy ivy;
    private long ivySettingsLastModified = -1L;
    private ModuleDescriptor md;

    public void reset() {
        this.md = null;
        this.ivy = null;
        this.ivySettingsLastModified = -1L;
    }

    public void setIvySettingsLastModified(long ivySettingsLastModified) {
        this.ivySettingsLastModified = ivySettingsLastModified;
    }

    public void setErrorMarker(IvyDEException ex) {
        IvyMarkerManager ivyMarkerManager = IvyPlugin.getDefault().getIvyMarkerManager();
        Object status = ex != null ? new Status(4, "org.apache.ivyde.eclipse", 4, ex.getMessage(), ex.getCause()) : Status.OK_STATUS;
        ivyMarkerManager.setResolveStatus((IStatus)status, this.getProject(), this.getIvyXmlPath());
    }

    protected abstract IProject getProject();

    protected abstract String getIvyXmlPath();

    protected abstract ResolvedPath getIvySettingsPath() throws IvyDEException;

    protected abstract boolean isLoadSettingsOnDemandPath();

    protected abstract ResolvedPath getIvyUserDir() throws IvyDEException;

    protected abstract Collection getPropertyFiles() throws IvyDEException;

    protected abstract boolean isResolveInWorkspace();

    protected abstract boolean isTransitiveResolve();

    public Ivy getCachedIvy() {
        if (this.ivy != null) {
            return this.ivy;
        }
        try {
            this.getIvy();
            this.setErrorMarker(null);
            return this.ivy;
        }
        catch (IvyDEException e) {
            this.setErrorMarker(e);
            return null;
        }
    }

    public Ivy getSafelyIvy() {
        try {
            this.getIvy();
            this.setErrorMarker(null);
            return this.ivy;
        }
        catch (IvyDEException e) {
            this.setErrorMarker(e);
            return null;
        }
    }

    public Ivy getIvy() throws IvyDEException {
        try {
            return this.doGetIvy();
        }
        catch (IvyDEException e) {
            e.contextualizeMessage("Error while resolving the ivy instance for " + this.toString());
            throw e;
        }
    }

    private Ivy doGetIvy() throws IvyDEException {
        ResolvedPath settingsPath = this.getIvySettingsPath();
        if (settingsPath.getError() != null) {
            throw new IvyDEException("Incorrect path of the Ivy settings", "The Ivy settings path '" + settingsPath.getInputPath() + "' is incorrect: " + settingsPath.getError().getMessage(), settingsPath.getError());
        }
        if (!settingsPath.isSet()) {
            IvyDEMessage.debug("No settings specified, so take the default one");
            if (this.ivy == null) {
                IvySettings ivySettings = this.createIvySettings();
                this.ivy = Ivy.newInstance((IvySettings)ivySettings);
                try {
                    this.ivy.configureDefault();
                }
                catch (ParseException e) {
                    this.ivy = null;
                    IvyDEException ex = new IvyDEException("Parsing error of the default Ivy settings", "The default Ivy settings file could not be parsed: " + e.getMessage(), e);
                    throw ex;
                }
                catch (IOException e) {
                    this.ivy = null;
                    throw new IvyDEException("Read error of the default Ivy settings", "The default Ivy settings file could not be read: " + e.getMessage(), e);
                }
            }
            return this.ivy;
        }
        if (settingsPath.getFile() != null) {
            return this.getIvyFromFile(settingsPath);
        }
        if (this.ivy == null || this.ivySettingsLastModified == -1L) {
            IvySettings ivySettings = this.createIvySettings();
            this.ivy = Ivy.newInstance((IvySettings)ivySettings);
            try {
                this.ivy.configure(settingsPath.getUrl());
                this.ivySettingsLastModified = 0L;
            }
            catch (ParseException e) {
                this.ivy = null;
                throw new IvyDEException("Parsing error of the Ivy settings", "The ivy settings file '" + settingsPath.getResolvedPath() + "' could not be parsed: " + e.getMessage(), e);
            }
            catch (IOException e) {
                this.ivy = null;
                throw new IvyDEException("Read error of the Ivy settings", "The ivy settings file '" + settingsPath.getResolvedPath() + "' could not be read: " + e.getMessage(), e);
            }
        }
        return this.ivy;
    }

    private Ivy getIvyFromFile(ResolvedPath ivySettingsPath) throws IvyDEException {
        File file = ivySettingsPath.getFile();
        IvyDEMessage.debug("Loading settings from local file " + file);
        if (!file.exists()) {
            throw new IvyDEException("Ivy settings file not found", "The Ivy settings file '" + ivySettingsPath.getResolvedPath() + "' cannot be found", null);
        }
        if (file.lastModified() != this.ivySettingsLastModified || !this.isLoadSettingsOnDemandPath()) {
            if (this.ivySettingsLastModified != -1L) {
                IvyDEMessage.info("Settings has changed, configuring Ivy again");
            }
            IvySettings ivySettings = this.createIvySettings();
            this.ivy = Ivy.newInstance((IvySettings)ivySettings);
            try {
                this.ivy.configure(file);
            }
            catch (ParseException e) {
                this.ivy = null;
                throw new IvyDEException("Parsing error of the Ivy settings", "The ivy settings file '" + ivySettingsPath.getResolvedPath() + "' could not be parsed: " + e.getMessage(), e);
            }
            catch (IOException e) {
                this.ivy = null;
                throw new IvyDEException("Read error of the Ivy settings", "The ivy settings file '" + ivySettingsPath.getResolvedPath() + "' could not be read: " + e.getMessage(), e);
            }
            this.ivySettingsLastModified = file.lastModified();
        } else {
            IvyDEMessage.verbose("No change detected: using cached version of the settings");
        }
        return this.ivy;
    }

    private IvySettings createIvySettings() throws IvyDEException {
        Collection propFiles;
        ResolvedPath ivyUserDir;
        IPath location;
        IvySettings ivySettings;
        if (this.isResolveInWorkspace()) {
            IvyDEMessage.verbose("Adding the workspace resolver to the settings");
            ivySettings = new WorkspaceIvySettings(this.getProject());
            DefaultRepositoryCacheManager cacheManager = new DefaultRepositoryCacheManager();
            BundleContext bundleContext = IvyPlugin.getDefault().getBundleContext();
            cacheManager.setBasedir(bundleContext.getDataFile("ivyde-workspace-resolver-cache"));
            cacheManager.setCheckmodified(true);
            cacheManager.setUseOrigin(true);
            cacheManager.setName("__ivyde-workspace-resolver-cache");
            ivySettings.addRepositoryCacheManager((RepositoryCacheManager)cacheManager);
        } else {
            ivySettings = new IvySettings();
        }
        if (this.getProject() != null && (location = this.getProject().getLocation()) != null) {
            ivySettings.setBaseDir(location.toFile());
        }
        if ((ivyUserDir = this.getIvyUserDir()).getError() != null) {
            throw new IvyDEException("Incorrect path of the Ivy user dir", "The Ivy user dir '" + ivyUserDir.getInputPath() + "' is incorrect: " + ivyUserDir.getError().getMessage(), ivyUserDir.getError());
        }
        if (ivyUserDir.isSet()) {
            ivySettings.setDefaultIvyUserDir(ivyUserDir.getFile());
        }
        if ((propFiles = this.getPropertyFiles()) == null || propFiles.isEmpty()) {
            IvyDEMessage.verbose("No property files to load");
        } else {
            IvyDEMessage.verbose(String.valueOf(propFiles.size()) + " property file(s) to load");
            Iterator iter = propFiles.iterator();
            while (iter.hasNext()) {
                FileInputStream is;
                String file = (String)iter.next();
                Path p = new Path(file);
                IvyDEMessage.debug("Loading property file " + p);
                if (this.getProject() != null && !p.isAbsolute()) {
                    try {
                        is = new FileInputStream(this.getProject().getLocation().append(file).toFile());
                    }
                    catch (FileNotFoundException e) {
                        throw new IvyDEException("Property file not found", "The property file '" + file + "' could not be found", e);
                    }
                }
                try {
                    is = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new IvyDEException("Property file not found", "The property file '" + file + "' was not found", e);
                }
                Properties props = new Properties();
                try {
                    props.load(is);
                }
                catch (IOException e) {
                    throw new IvyDEException("Not a property file", "The property file '" + file + "' could not be loaded", e);
                }
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
                Iterator<Object> keys = props.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = props.getProperty(key);
                    ivySettings.setVariable(key, value);
                }
            }
        }
        return ivySettings;
    }

    public File getIvyFile() throws IvyDEException {
        ResolvedPath ivyPath = new ResolvedPath(this.getIvyXmlPath(), this.getProject());
        if (ivyPath.getError() != null) {
            throw new IvyDEException("Incorrect path of the ivy.xml", "The ivy.xml path '" + ivyPath.getInputPath() + "' is incorrect: " + ivyPath.getError().getMessage(), ivyPath.getError());
        }
        if (!ivyPath.isSet()) {
            throw new IvyDEException("Empty path of the ivy.xml", "The ivy.xml path is resolved to be empty: '" + ivyPath.getInputPath() + "'", null);
        }
        if (ivyPath.getFile() == null) {
            throw new IvyDEException("The path of the ivy.xml is not a local file", "The ivy.xml path is resolved to be a file: '" + ivyPath.getResolvedPath() + "'", null);
        }
        return ivyPath.getFile();
    }

    public ModuleDescriptor getCachedModuleDescriptor() {
        if (this.md != null) {
            return this.md;
        }
        try {
            if (this.ivy == null) {
                this.ivy = this.getIvy();
            }
            this.getModuleDescriptor(this.ivy);
            this.setErrorMarker(null);
            return this.md;
        }
        catch (IvyDEException e) {
            this.setErrorMarker(e);
            return null;
        }
    }

    public ModuleDescriptor getModuleDescriptor() throws IvyDEException {
        return this.getModuleDescriptor(this.getIvy());
    }

    public ModuleDescriptor getCachedModuleDescriptor(Ivy i) {
        if (this.md != null) {
            return this.md;
        }
        try {
            this.getModuleDescriptor(i);
            this.setErrorMarker(null);
            return this.md;
        }
        catch (IvyDEException e) {
            this.setErrorMarker(e);
            return null;
        }
    }

    public ModuleDescriptor getSafelyModuleDescriptor(Ivy i) {
        try {
            this.getModuleDescriptor(i);
            this.setErrorMarker(null);
            return this.md;
        }
        catch (IvyDEException e) {
            this.setErrorMarker(e);
            return null;
        }
    }

    public ModuleDescriptor getModuleDescriptor(Ivy i) throws IvyDEException {
        File file = this.getIvyFile();
        if (!file.exists()) {
            throw new IvyDEException("Ivy file not found", "The ivy.xml file '" + file.getAbsolutePath() + "' was not found", null);
        }
        try {
            this.md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor((ParserSettings)i.getSettings(), file.toURI().toURL(), false);
            return this.md;
        }
        catch (MalformedURLException e) {
            throw new IvyDEException("Incorrect URL of the Ivy file", "The URL to the ivy.xml file is incorrect: '" + file.getAbsolutePath() + "'", e);
        }
        catch (ParseException e) {
            throw new IvyDEException("Parsing error of the Ivy file", "The ivy file '" + file.getAbsolutePath() + "' could not be parsed: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IvyDEException("Read error of the Ivy file", "The ivy file '" + file.getAbsolutePath() + "' could not be read: " + e.getMessage(), e);
        }
    }
}

