/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse;

import java.util.ArrayList;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.IvyMarkerManager;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class IvyNature
implements IProjectNature {
    private IProject project;

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        if (!javaProject.exists()) {
            return;
        }
        IClasspathEntry[] classpathEntries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < classpathEntries.length) {
            if (!IvyClasspathContainerHelper.isIvyClasspathContainer(classpathEntries[i].getPath())) {
                newEntries.add(classpathEntries[i]);
            }
            ++i;
        }
        if (newEntries.size() != classpathEntries.length) {
            IClasspathEntry[] newClasspathEntries = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
            javaProject.setRawClasspath(newClasspathEntries, null);
        }
        IvyMarkerManager ivyMarkerManager = IvyPlugin.getDefault().getIvyMarkerManager();
        ivyMarkerManager.removeMarkers((IResource)this.project);
    }
}

