/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.editors;

import java.util.Iterator;
import java.util.List;
import org.apache.ivyde.common.ivysettings.IvySettingsModel;
import org.apache.ivyde.common.model.IvyModel;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.ui.core.IvyFileEditorInput;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.EclipseIvyModelSettings;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.IvyContentAssistProcessor;
import org.apache.ivyde.internal.eclipse.ui.editors.xml.XMLEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class IvySettingsEditor
extends FormEditor
implements IResourceChangeListener {
    public static final String ID = "org.apache.ivyde.editors.IvySettingsEditor";
    private XMLEditor xmlEditor;

    public IvySettingsEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void setInput(IEditorInput input) {
        IvyFileEditorInput ivyFileEditorInput = null;
        if (input instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)input;
            IFile file = fei.getFile();
            ivyFileEditorInput = new IvyFileEditorInput(file);
        } else if (input instanceof IvyFileEditorInput) {
            ivyFileEditorInput = (IvyFileEditorInput)input;
        }
        super.setInput((IEditorInput)ivyFileEditorInput);
        if (ivyFileEditorInput.getFile() != null && this.xmlEditor != null) {
            this.xmlEditor.setFile(ivyFileEditorInput.getFile());
        }
        this.setPartName(ivyFileEditorInput.getFile().getName());
    }

    void createPageXML() {
        try {
            this.xmlEditor = new XMLEditor(new IvyContentAssistProcessor(){

                protected IvyModel newCompletionModel(IFile file) {
                    return new IvySettingsModel(new EclipseIvyModelSettings(this.getJavaProject()), file.getFullPath().toFile());
                }
            });
            this.xmlEditor.setFile(((IvyFileEditorInput)this.getEditorInput()).getFile());
            int index = this.addPage((IEditorPart)this.xmlEditor, this.getEditorInput());
            this.setPageText(index, this.xmlEditor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    protected void addPages() {
        this.createPageXML();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.xmlEditor.doSave(monitor);
        IFile file = ((IvyFileEditorInput)this.getEditorInput()).getFile();
        List containers = IvyClasspathContainerHelper.getContainersFromIvySettings(file);
        Iterator itContainers = containers.iterator();
        while (itContainers.hasNext()) {
            IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)itContainers.next();
            ivycp.launchResolve(false, null);
        }
    }

    public void doSaveAs() {
        this.xmlEditor.doSaveAs();
        this.setPageText(0, this.xmlEditor.getTitle());
        this.setInput(this.xmlEditor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return this.xmlEditor.isSaveAsAllowed();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            final IResource res = event.getResource();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = IvySettingsEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((IFileEditorInput)IvySettingsEditor.this.xmlEditor.getEditorInput()).getFile().getProject().equals((Object)res)) {
                            IEditorPart editorPart = pages[i].findEditor(IvySettingsEditor.this.xmlEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }
}

