/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.menu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivyde.eclipse.IvyNatureHelper;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathUtil;
import org.apache.ivyde.internal.eclipse.retrieve.RetrieveSetupManager;
import org.apache.ivyde.internal.eclipse.retrieve.StandaloneRetrieveSetup;
import org.apache.ivyde.internal.eclipse.ui.menu.CleanCacheAction;
import org.apache.ivyde.internal.eclipse.ui.menu.IvyMenuSeparator;
import org.apache.ivyde.internal.eclipse.ui.menu.RetrieveAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class IvyMenuContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void initialize(IServiceLocator locator) {
        this.serviceLocator = locator;
    }

    protected IContributionItem[] getContributionItems() {
        List<Object> items;
        MenuManager menuManager;
        ISelectionService selectionService;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.ISelectionService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((selectionService = (ISelectionService)this.serviceLocator.getService((Class)clazz)) == null) {
            return new IContributionItem[0];
        }
        ISelection selection = selectionService.getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return new IContributionItem[0];
        }
        HashMap containers = new HashMap();
        HashMap retrieveSetups = new HashMap();
        boolean onlyContainers = true;
        int totalSelected = 0;
        Iterator it = ((IStructuredSelection)selection).iterator();
        while (it.hasNext()) {
            IWorkingSet workingSet;
            ++totalSelected;
            Object element = it.next();
            boolean projectCollected = this.collectProject(containers, retrieveSetups, element);
            if (projectCollected) {
                onlyContainers = false;
                continue;
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.ui.IWorkingSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((workingSet = (IWorkingSet)IvyPlugin.adapt(element, clazz2)) != null) {
                onlyContainers = false;
                IAdaptable[] elements = workingSet.getElements();
                int i = 0;
                while (i < elements.length) {
                    this.collectProject(containers, retrieveSetups, elements[i]);
                    ++i;
                }
                continue;
            }
            if (!(element instanceof ClassPathContainer)) continue;
            this.collectContainer(containers, (ClassPathContainer)element);
        }
        if (onlyContainers) {
            menuManager = null;
            items = new ArrayList();
        } else {
            menuManager = new MenuManager("Ivy", IvyPlugin.getImageDescriptor("icons/logo16x16.gif"), "org.apache.ivyde.eclipse.menu");
            items = Collections.singletonList(menuManager);
        }
        if (!containers.isEmpty()) {
            this.addCommand(menuManager, items, "org.apache.ivyde.commands.resolve");
            this.addCommand(menuManager, items, "org.apache.ivyde.commands.refresh");
            this.addCommand(menuManager, items, "org.apache.ivyde.commands.reloadsettings");
            this.fillMenu(menuManager, items, (IContributionItem)new IvyMenuSeparator());
        }
        if (!retrieveSetups.isEmpty()) {
            boolean oneProject = retrieveSetups.size() == 1 && totalSelected == 1;
            Iterator itProject = retrieveSetups.entrySet().iterator();
            while (itProject.hasNext()) {
                Map.Entry entry = itProject.next();
                IProject project = (IProject)entry.getKey();
                Iterator itSetup = ((Set)entry.getValue()).iterator();
                while (itSetup.hasNext()) {
                    StandaloneRetrieveSetup retrieveSetup = (StandaloneRetrieveSetup)itSetup.next();
                    RetrieveAction action = new RetrieveAction(retrieveSetup);
                    action.setText("Retrieve '" + retrieveSetup.getName() + (oneProject ? "'" : "' of " + project.getName()));
                    this.fillMenu(menuManager, items, (IContributionItem)new ActionContributionItem((IAction)action));
                }
            }
            this.fillMenu(menuManager, items, (IContributionItem)new IvyMenuSeparator());
        }
        if (!containers.isEmpty()) {
            this.addCommand(menuManager, items, "org.apache.ivyde.commands.openivyfile");
            this.fillMenu(menuManager, items, (IContributionItem)new IvyMenuSeparator());
        }
        if (!containers.isEmpty()) {
            if (totalSelected == 1 && containers.size() == 1 && ((Set)containers.values().iterator().next()).size() == 1) {
                IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)((Set)containers.values().iterator().next()).iterator().next();
                Ivy ivy = ivycp.getState().getCachedIvy();
                if (ivy != null) {
                    this.addCleanableForSingleContainer(menuManager, items, ivy);
                }
            } else {
                this.addCleanableForManyContainers(menuManager, items, containers.values());
            }
            this.fillMenu(menuManager, items, (IContributionItem)new IvyMenuSeparator());
        }
        if (!containers.isEmpty()) {
            this.addCommand(menuManager, items, "org.apache.ivyde.commands.revdepexplorer");
            this.fillMenu(menuManager, items, (IContributionItem)new IvyMenuSeparator());
        }
        this.addCommand(menuManager, items, "org.apache.ivyde.commands.removeivynature");
        return items.toArray(new IContributionItem[items.size()]);
    }

    private void addCommand(MenuManager menuManager, List items, String commandId) {
        CommandContributionItemParameter parm = new CommandContributionItemParameter(this.serviceLocator, null, commandId, 8);
        this.fillMenu(menuManager, items, (IContributionItem)new CommandContributionItem(parm));
    }

    private void fillMenu(MenuManager menuManager, List items, IContributionItem item) {
        if (menuManager != null) {
            menuManager.add(item);
        } else {
            items.add(item);
        }
    }

    private boolean collectProject(Map containers, Map retrieveSetups, Object element) {
        IProject project;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((project = (IProject)IvyPlugin.adapt(element, clazz)) != null && project.isOpen() && IvyNatureHelper.hasNature(project)) {
            this.doCollectProject(containers, retrieveSetups, project);
            return true;
        }
        return false;
    }

    private void doCollectProject(Map containers, Map retrieveSetups, IProject project) {
        List setupList;
        List ivycps = IvyClasspathContainerHelper.getContainers(project);
        if (!ivycps.isEmpty()) {
            containers.put(project, new HashSet(ivycps));
        }
        RetrieveSetupManager manager = IvyPlugin.getDefault().getRetrieveSetupManager();
        try {
            setupList = manager.getSetup(project);
        }
        catch (IOException e) {
            IvyPlugin.logWarn("Unable to get the retrieve setup for project " + project.getName(), e);
            return;
        }
        if (!setupList.isEmpty()) {
            retrieveSetups.put(project, new HashSet(setupList));
        }
    }

    private boolean collectContainer(Map containers, ClassPathContainer element) {
        IvyClasspathContainerImpl ivycp = IvyClasspathUtil.jdt2IvyCPC(element);
        if (ivycp == null) {
            return false;
        }
        this.doCollectContainer(containers, ivycp);
        return true;
    }

    private void doCollectContainer(Map containers, IvyClasspathContainerImpl ivycp) {
        IJavaProject javaProject = ivycp.getConf().getJavaProject();
        if (javaProject == null) {
            return;
        }
        HashSet<IvyClasspathContainerImpl> cplist = (HashSet<IvyClasspathContainerImpl>)containers.get(javaProject.getProject());
        if (cplist == null) {
            cplist = new HashSet<IvyClasspathContainerImpl>();
            containers.put(javaProject.getProject(), cplist);
        }
        cplist.add(ivycp);
    }

    private void addCleanableForSingleContainer(MenuManager menuManager, List items, Ivy ivy) {
        ArrayList allCleanables = new ArrayList();
        ArrayList repositoryCleanables = new ArrayList();
        ArrayList resolutionCleanables = new ArrayList();
        this.addResolutionCleanable(allCleanables, ivy);
        this.addResolutionCleanable(resolutionCleanables, ivy);
        this.addRepositoryCleanable(allCleanables, ivy);
        this.addRepositoryCleanable(repositoryCleanables, ivy);
        this.addCleanable(menuManager, items, "Clean all caches", allCleanables);
        this.addCleanable(menuManager, items, "Clean the resolution cache", resolutionCleanables);
        this.addCleanable(menuManager, items, "Clean every repository cache", repositoryCleanables);
        Iterator itCleanble = resolutionCleanables.iterator();
        while (itCleanble.hasNext()) {
            CleanCacheAction.Cleanable cleanable = (CleanCacheAction.Cleanable)itCleanble.next();
            this.addCleanable(menuManager, items, "Clean the cache '" + cleanable.getName() + "'", Collections.singletonList(cleanable));
        }
    }

    private void addCleanableForManyContainers(MenuManager menuManager, List items, Collection containerSets) {
        ArrayList allCleanables = new ArrayList();
        ArrayList repositoryCleanables = new ArrayList();
        ArrayList resolutionCleanables = new ArrayList();
        Iterator itSet = containerSets.iterator();
        while (itSet.hasNext()) {
            Set set = (Set)itSet.next();
            Iterator itContainer = set.iterator();
            while (itContainer.hasNext()) {
                IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)itContainer.next();
                Ivy ivy = ivycp.getState().getCachedIvy();
                if (ivy == null) continue;
                this.addResolutionCleanable(allCleanables, ivy);
                this.addResolutionCleanable(resolutionCleanables, ivy);
                this.addRepositoryCleanable(allCleanables, ivy);
                this.addRepositoryCleanable(repositoryCleanables, ivy);
            }
        }
        this.addCleanable(menuManager, items, "Clean all caches", allCleanables);
        this.addCleanable(menuManager, items, "Clean every resolution cache", resolutionCleanables);
        this.addCleanable(menuManager, items, "Clean every repository cache", repositoryCleanables);
    }

    private void addResolutionCleanable(List cleanables, Ivy ivy) {
        ResolutionCacheManager manager = ivy.getSettings().getResolutionCacheManager();
        cleanables.add(new CleanCacheAction.ResolutionCacheCleanable(manager));
    }

    private void addRepositoryCleanable(List cleanables, Ivy ivy) {
        RepositoryCacheManager[] managers = ivy.getSettings().getRepositoryCacheManagers();
        int i = 0;
        while (i < managers.length) {
            cleanables.add(new CleanCacheAction.RepositoryCacheCleanable(managers[i]));
            ++i;
        }
    }

    public void addCleanable(MenuManager menuManager, List items, String name, List cleanables) {
        CleanCacheAction action = new CleanCacheAction(name, cleanables);
        action.setText(name);
        this.fillMenu(menuManager, items, (IContributionItem)new ActionContributionItem((IAction)action));
    }
}

