/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.workspaceresolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.ivyde.eclipse.IvyNatureHelper;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class WorkspaceResourceChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        block14: {
            try {
                if (event.getType() == 2 || event.getType() == 4) {
                    IProject project;
                    if (!IvyPlugin.getPreferenceStoreHelper().getAutoResolveOnClose()) {
                        return;
                    }
                    IResource res = event.getResource();
                    switch (res.getType()) {
                        case 2: {
                            project = ((IFolder)res).getProject();
                            break;
                        }
                        case 1: {
                            project = ((IFile)res).getProject();
                            break;
                        }
                        case 4: {
                            project = (IProject)res;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    try {
                        if (IvyNatureHelper.hasNature(project)) {
                            this.projectClosed(project);
                        }
                        break block14;
                    }
                    catch (CoreException coreException) {}
                    break block14;
                }
                if (event.getType() == 1) {
                    if (!IvyPlugin.getPreferenceStoreHelper().getAutoResolveOnOpen()) {
                        return;
                    }
                    this.projectOpened(event);
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                IvyPlugin.log(8, "Ivy update of dependent proejects affected by project close operation canceled", null);
            }
        }
    }

    private void projectClosed(IProject project) throws JavaModelException {
        List containers = IvyClasspathContainerHelper.getContainers(project);
        if (containers.isEmpty()) {
            return;
        }
        List affectedContainers = this.getAffectedContainers(project.getFullPath());
        Iterator it = affectedContainers.iterator();
        while (it.hasNext()) {
            IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)it.next();
            ivycp.launchResolve(false, null);
        }
    }

    private void projectOpened(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        LinkedHashSet<IResource> projects = new LinkedHashSet<IResource>();
        IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
        int i = 0;
        while (i < projDeltas.length) {
            IResource resource;
            IResourceDelta projDelta = projDeltas[i];
            if ((projDelta.getFlags() & 0x4000) != 0 && (resource = projDeltas[i].getResource()) instanceof IProject && IvyNatureHelper.hasNature((IProject)resource)) {
                projects.add(resource);
            }
            ++i;
        }
        if (projects.size() == 0) {
            return;
        }
        List allContainers = this.getAllContainersExcludingProjects(projects);
        Iterator it = allContainers.iterator();
        while (it.hasNext()) {
            IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)it.next();
            ivycp.launchResolve(false, null);
        }
    }

    private List getAffectedContainers(IPath projectPath) {
        IJavaProject[] projects;
        ArrayList<IvyClasspathContainerImpl> allContainers = new ArrayList<IvyClasspathContainerImpl>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        }
        catch (JavaModelException e) {
            IvyPlugin.log((CoreException)((Object)e));
            return allContainers;
        }
        int i = 0;
        while (i < projects.length) {
            IJavaProject javaProject = projects[i];
            List containers = IvyClasspathContainerHelper.getContainers(javaProject);
            Iterator itContainer = containers.iterator();
            block3: while (itContainer.hasNext()) {
                IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)itContainer.next();
                IClasspathEntry[] containerEntries = ivycp.getClasspathEntries();
                int j = 0;
                while (j < containerEntries.length) {
                    IClasspathEntry containerEntry = containerEntries[j];
                    if (containerEntry != null && containerEntry.getEntryKind() == 2 && containerEntry.getPath().equals((Object)projectPath)) {
                        allContainers.add(ivycp);
                        continue block3;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return allContainers;
    }

    private List getAllContainersExcludingProjects(Collection openedProjects) {
        IJavaProject[] projects;
        ArrayList allContainers = new ArrayList();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        }
        catch (JavaModelException e) {
            IvyPlugin.log((CoreException)((Object)e));
            return allContainers;
        }
        int i = 0;
        while (i < projects.length) {
            if (!openedProjects.contains(projects[i].getProject())) {
                allContainers.addAll(IvyClasspathContainerHelper.getContainers(projects[i]));
            }
            ++i;
        }
        return allContainers;
    }
}

