/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.wsil.Service;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesWSDLServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public class FavoritesWSDLServiceFolderElement
extends FavoritesFolderElement {
    public FavoritesWSDLServiceFolderElement(String name, Model model, NodeManager nodeManager) {
        super(name, model, nodeManager);
    }

    public void init(FavoritesMainElement favMainElement) {
        Service[] services = favMainElement.loadWSDLServices();
        int i = 0;
        while (i < services.length) {
            Service service = services[i];
            FavoritesWSDLServiceElement favWSDLServiceElement = new FavoritesWSDLServiceElement(service.getDescriptions()[0].getLocation(), this.getModel(), service);
            this.connect((Element)favWSDLServiceElement, "relWSDLServiceNode", "owner");
            ++i;
        }
    }

    public boolean addFavorite(Hashtable table) {
        String wsdlURL = (String)table.get("wsdlURL");
        if (wsdlURL == null) {
            return false;
        }
        FavoritesWSDLServiceElement e = this.getFavorite(wsdlURL);
        if (e != null) {
            this.removeFavorite(e);
        }
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Service service = favMainElement.addWSDLService(wsdlURL);
        boolean saved = favMainElement.saveFavorites();
        if (saved) {
            FavoritesWSDLServiceElement favWSDLServiceElement = new FavoritesWSDLServiceElement(wsdlURL, this.getModel(), service);
            this.connect((Element)favWSDLServiceElement, "relWSDLServiceNode", "owner");
        }
        return saved;
    }

    public boolean favoriteExists(Hashtable table) {
        String wsdlURL = (String)table.get("wsdlURL");
        if (wsdlURL == null) {
            return false;
        }
        return this.getFavorite(wsdlURL) != null;
    }

    public boolean removeFavoriteByNodeID(int nodeID, String pluginMetadataDirectory) {
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        TreeElement selectedElement = selectedNode.getTreeElement();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (selectedElement instanceof FavoritesWSDLServiceElement) {
            return this.removeFavorite((FavoritesWSDLServiceElement)selectedElement) && favMainElement.saveFavorites();
        }
        return false;
    }

    private boolean removeFavorite(FavoritesWSDLServiceElement element) {
        Service service = element.getService();
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        if (favMainElement.removeService(service)) {
            element.disconnectAll();
            return true;
        }
        return false;
    }

    public boolean removeAllFavorites(String pluginMetadataDirectory) {
        FavoritesMainElement favMainElement = this.getFavoritesMainElement();
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesWSDLServiceElement favWSDLServiceElement = (FavoritesWSDLServiceElement)((Object)e.nextElement());
            Service service = favWSDLServiceElement.getService();
            favMainElement.removeService(service);
        }
        this.disconnectRel("relWSDLServiceNode");
        return favMainElement.saveFavorites();
    }

    public Enumeration getAllFavorites() {
        return this.getElements("relWSDLServiceNode");
    }

    private FavoritesWSDLServiceElement getFavorite(String wsdlUrl) {
        Enumeration e = this.getAllFavorites();
        while (e.hasMoreElements()) {
            FavoritesWSDLServiceElement wsdlElement = (FavoritesWSDLServiceElement)((Object)e.nextElement());
            if (!wsdlUrl.equals(wsdlElement.getWsdlUrl())) continue;
            return wsdlElement;
        }
        return null;
    }
}

