/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.action;

import com.liferay.ide.server.core.ILiferayServer;
import com.liferay.ide.server.ui.LiferayServerUIPlugin;
import com.liferay.ide.server.ui.action.AbstractServerRunningAction;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;

public abstract class OpenPortalURLAction
extends AbstractServerRunningAction {
    protected ILiferayServer getLiferayServer() {
        return (ILiferayServer)this.selectedServer.loadAdapter(ILiferayServer.class, null);
    }

    protected abstract URL getPortalURL();

    protected abstract String getPortalURLTitle();

    protected int getRequiredServerState() {
        return 2;
    }

    protected void openBrowser(final URL url, final String browserTitle) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchBrowserSupport browserSupport = ServerUIPlugin.getInstance().getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(6, null, browserTitle, null);
                    browser.openURL(url);
                }
                catch (Exception e) {
                    LiferayServerUIPlugin.logError(e);
                }
            }
        });
    }

    protected void openPortalURL(ILiferayServer portalServer) {
        URL portalUrl = this.getPortalURL();
        if (portalUrl == null) {
            MessageDialog.openError((Shell)this.getActiveShell(), (String)Msgs.openPortalURL, (String)Msgs.notDeterminePortalURL);
            return;
        }
        this.openBrowser(portalUrl, this.getPortalURLTitle());
    }

    public void run(IAction action) {
        if (this.selectedServer != null) {
            final ILiferayServer portalServer = this.getLiferayServer();
            new Job(Msgs.openPortalUrl){

                protected IStatus run(IProgressMonitor monitor) {
                    OpenPortalURLAction.this.openPortalURL(portalServer);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private static class Msgs
    extends NLS {
        public static String notDeterminePortalURL;
        public static String openPortalURL;
        public static String openPortalUrl;

        static {
            Msgs.initializeMessages((String)OpenPortalURLAction.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

