/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.core.descriptor;

import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.project.core.BaseValidator;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.service.core.ServiceCore;
import com.liferay.ide.service.core.util.ServiceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBuilderDescriptorValidator
extends BaseValidator {
    public static final String MARKER_TYPE = "com.liferay.ide.service.core.serviceBuilderDescriptorMarker";
    public static final String MESSAGE_NAMESPACE_INVALID = Msgs.namespaceInvalid;
    public static final String NAMESPACE_ELEMENT = "namespace";
    public static final String PACKAGE_PATH_ATTRIBUTE = "package-path";
    public static final String PREFERENCE_NODE_QUALIFIER = LiferayProjectCore.getDefault().getBundle().getSymbolicName();

    protected void checkNamespaceElements(IDOMDocument document, IScopeContext[] preferenceScopes, String validationKey, List<Map<String, Object>> problems) {
        Map problem;
        Node item;
        String namespace;
        NodeList namespaces = document.getElementsByTagName(NAMESPACE_ELEMENT);
        if (namespaces.getLength() > 0 && !ServiceUtil.isValidNamespace(namespace = NodeUtil.getTextContent((Node)(item = namespaces.item(0)))) && (problem = this.createMarkerValues(PREFERENCE_NODE_QUALIFIER, preferenceScopes, validationKey, (IDOMNode)item, MESSAGE_NAMESPACE_INVALID)) != null) {
            problems.add(problem);
        }
    }

    protected void checkPackagePath(Node serviceBuilderNode, IScopeContext[] preferenceScopes, String validationKey, List<Map<String, Object>> problems) {
        String packPathVal;
        Node packagePath = serviceBuilderNode.getAttributes().getNamedItem(PACKAGE_PATH_ATTRIBUTE);
        if (packagePath != null && (packPathVal = packagePath.getNodeValue()) != null && packPathVal.trim().length() > 0) {
            IStatus javaStatus = JavaConventions.validatePackageName((String)packPathVal, (String)"1.5", (String)"1.5");
            HashMap problem = null;
            if (javaStatus.getSeverity() == 4) {
                String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACAKGE_NAME_INVALID) + javaStatus.getMessage();
                problem = this.createMarkerValues(PREFERENCE_NODE_QUALIFIER, preferenceScopes, validationKey, (IDOMNode)packagePath, msg);
            } else if (javaStatus.getSeverity() == 2) {
                Integer severity = this.getMessageSeverity(PREFERENCE_NODE_QUALIFIER, preferenceScopes, validationKey);
                if (severity == null) {
                    problem = null;
                } else {
                    String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACKAGE_NAME_WARNING) + javaStatus.getMessage();
                    HashMap markerValues = new HashMap();
                    this.setMarkerValues(markerValues, new Integer(1), (IDOMNode)packagePath, msg);
                    problem = markerValues;
                }
            }
            if (problem != null) {
                problems.add(problem);
            }
        }
    }

    protected void checkPackagePaths(IDOMDocument document, IScopeContext[] preferenceScopes, String validationKey, List<Map<String, Object>> problems) {
        Element serviceBuilderElement = document.getDocumentElement();
        if (serviceBuilderElement != null) {
            this.checkPackagePath(serviceBuilderElement, preferenceScopes, validationKey, problems);
        }
    }

    protected Map<String, Object>[] detectProblems(IJavaProject javaProject, IFile serviceXml, IScopeContext[] preferenceScopes) throws CoreException {
        ArrayList<Map<String, Object>> problems;
        block9: {
            problems = new ArrayList<Map<String, Object>>();
            IStructuredModel model = null;
            try {
                try {
                    model = StructuredModelManager.getModelManager().getModelForRead(serviceXml);
                    if (model instanceof IDOMModel) {
                        IDOMDocument document = ((IDOMModel)model).getDocument();
                        this.checkNamespaceElements(document, preferenceScopes, "validation-service-xml-namespace-invalid", problems);
                        this.checkPackagePaths(document, preferenceScopes, "validation-service-xml-package-path-invalid", problems);
                    }
                }
                catch (IOException e) {
                    ServiceCore.logError(e);
                    if (model != null) {
                        model.releaseFromRead();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (model != null) {
                    model.releaseFromRead();
                }
                throw throwable;
            }
            if (model != null) {
                model.releaseFromRead();
            }
        }
        Map[] retval = new Map[problems.size()];
        return problems.toArray(retval);
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        IJavaProject javaProject;
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IFile serviceXml = (IFile)resource;
        if (serviceXml.isAccessible() && ProjectUtil.isPortletProject((IProject)resource.getProject()) && (javaProject = JavaCore.create((IProject)serviceXml.getProject())).exists()) {
            IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
            ProjectScope projectScope = new ProjectScope(serviceXml.getProject());
            boolean useProjectSettings = projectScope.getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("use-project-settings", false);
            if (useProjectSettings) {
                scopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
            }
            try {
                Map<String, Object>[] problems = this.detectProblems(javaProject, serviceXml, scopes);
                int i = 0;
                while (i < problems.length) {
                    ValidatorMessage message = ValidatorMessage.create((String)problems[i].get("message").toString(), (IResource)resource);
                    message.setType(MARKER_TYPE);
                    message.setAttributes(problems[i]);
                    result.add(message);
                    ++i;
                }
            }
            catch (Exception e) {
                ServiceCore.logError(e);
            }
        }
        return result;
    }

    private static class Msgs
    extends NLS {
        public static String namespaceInvalid;

        static {
            Msgs.initializeMessages((String)ServiceBuilderDescriptorValidator.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

