/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.core.model.internal;

import com.liferay.ide.service.core.model.Column;
import com.liferay.ide.service.core.model.Entity;
import com.liferay.ide.service.core.model.Relationship;
import com.liferay.ide.service.core.model.ServiceBuilder;
import com.liferay.ide.service.core.model.internal.EntityRelationshipService;
import com.liferay.ide.service.core.model.internal.RelationshipObject;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;

public class RelationshipResource
extends Resource {
    private RelationshipObject relationshipObject;

    public RelationshipResource(RelationshipObject obj, Resource parent) {
        super(parent);
        this.relationshipObject = obj;
    }

    protected PropertyBinding createBinding(Property property) {
        ValuePropertyBinding binding = null;
        if (Relationship.PROP_FROM_ENTITY.equals(property)) {
            binding = new ValuePropertyBinding(){

                public String read() {
                    return RelationshipResource.this.relationshipObject.getFromName();
                }

                public void write(String value) {
                    RelationshipResource.this.relationshipObject.setFromName(value);
                    RelationshipResource.this.persistRelationship();
                }
            };
        } else if (Relationship.PROP_TO_ENTITY.equals(property)) {
            binding = new ValuePropertyBinding(){

                public String read() {
                    return RelationshipResource.this.relationshipObject.getToName();
                }

                public void write(String value) {
                    RelationshipResource.this.relationshipObject.setToName(value);
                    RelationshipResource.this.persistRelationship();
                }
            };
        }
        if (binding != null) {
            binding.init(property);
        }
        return binding;
    }

    public RelationshipObject getRelationshipObject() {
        return this.relationshipObject;
    }

    private void persistRelationship() {
        ServiceBuilder serviceBuilder = (ServiceBuilder)this.parent().element().nearest(ServiceBuilder.class);
        String fromName = this.relationshipObject.getFromName();
        String toName = this.relationshipObject.getToName();
        Entity fromEntity = EntityRelationshipService.findEntity(fromName, serviceBuilder);
        Entity toEntity = EntityRelationshipService.findEntity(toName, serviceBuilder);
        if (fromEntity != null && toEntity != null) {
            Column primaryKeyColumn = null;
            for (Column column : toEntity.getColumns()) {
                if (!((Boolean)column.isPrimary().content()).booleanValue()) continue;
                primaryKeyColumn = column;
                break;
            }
            if (primaryKeyColumn != null) {
                Column column;
                column = (Column)fromEntity.getColumns().insert();
                column.setName((String)primaryKeyColumn.getName().content());
                column.setType("long");
            }
        }
    }
}

