/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.notifications.feed;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.notifications.core.IFilterable;
import org.eclipse.mylyn.commons.notifications.core.NotificationEnvironment;
import org.eclipse.mylyn.internal.commons.notifications.feed.FeedEntry;

public class FeedReader {
    private final NotificationEnvironment environment;
    private final List<FeedEntry> entries;
    private final String eventId;

    public FeedReader(String eventId, NotificationEnvironment environment) {
        this.eventId = eventId;
        this.environment = environment;
        this.entries = new ArrayList<FeedEntry>();
    }

    public IStatus parse(InputStream in, IProgressMonitor monitor) {
        SyndFeedInput input = new SyndFeedInput();
        try {
            SyndFeed feed = input.build((Reader)new XmlReader(in));
            for (SyndEntry syndEntry : feed.getEntries()) {
                final FeedEntry entry = this.createEntry(syndEntry);
                if (!this.environment.matches(new IAdaptable(){

                    public Object getAdapter(Class adapter) {
                        if (adapter == IFilterable.class) {
                            return new IFilterable(){

                                public List<String> getFilters(String key) {
                                    return entry.getFilters(key);
                                }

                                public String getFilter(String key) {
                                    return entry.getFilter(key);
                                }
                            };
                        }
                        if (adapter == FeedEntry.class) {
                            return entry;
                        }
                        return null;
                    }
                }, monitor)) continue;
                this.entries.add(entry);
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.mylyn.commons.notifications.feed", 4, "Failed to parse RSS feed", (Throwable)e);
        }
    }

    protected FeedEntry createEntry(SyndEntry syndEntry) {
        return new FeedEntry(this.eventId, syndEntry);
    }

    public List<FeedEntry> getEntries() {
        return this.entries;
    }
}

