/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.action;

import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.portlet.core.job.BuildLanguageJob;
import com.liferay.ide.portlet.ui.PortletUIPlugin;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.ui.action.AbstractObjectAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class BuildLanguagesAction
extends AbstractObjectAction {
    public void run(IAction action) {
        IFile langFile = null;
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            Object elem = elems[0];
            if (elem instanceof IFile) {
                langFile = (IFile)elem;
            } else if (elem instanceof IProject) {
                IFolder[] srcFolders;
                IProject project = (IProject)elem;
                IFolder[] iFolderArray = srcFolders = ProjectUtil.getSourceFolders((IProject)project);
                int n = srcFolders.length;
                int n2 = 0;
                while (n2 < n) {
                    IFolder src = iFolderArray[n2];
                    IFile file = src.getFile("content/Language.properties");
                    if (file.exists()) {
                        langFile = file;
                        break;
                    }
                    ++n2;
                }
            }
            if (langFile.exists()) {
                try {
                    boolean shouldContinue = this.checkLanguageFileEncoding(langFile);
                    if (!shouldContinue) {
                        return;
                    }
                }
                catch (Exception e2) {
                    PortletUIPlugin.createErrorStatus(e2);
                }
                BuildLanguageJob job = PortletCore.createBuildLanguageJob((IFile)langFile);
                job.schedule();
            }
        }
    }

    protected boolean checkLanguageFileEncoding(IFile langFile) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            langFile.refreshLocal(2, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            PortletUIPlugin.logError(e);
        }
        String charset = langFile.getCharset(true);
        if (!"UTF-8".equals(charset)) {
            String dialogMessage = NLS.bind((String)Msgs.languageFileCharacterSet, (Object)charset);
            MessageDialog dialog = new MessageDialog(this.getDisplay().getActiveShell(), Msgs.incompatibleCharacterSet, this.getDisplay().getSystemImage(8), dialogMessage, 4, new String[]{Msgs.yes, Msgs.no, Msgs.cancel}, 0);
            int retval = dialog.open();
            if (retval == 0) {
                langFile.setCharset("UTF-8", (IProgressMonitor)monitor);
                String question = NLS.bind((String)Msgs.forcedEditFile, (Object)langFile.getName());
                if (MessageDialog.openQuestion((Shell)this.getDisplay().getActiveShell(), (String)Msgs.previewFile, (String)question)) {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)langFile);
                }
                return false;
            }
            if (retval == 2) {
                return false;
            }
        }
        return true;
    }

    private static class Msgs
    extends NLS {
        public static String cancel;
        public static String forcedEditFile;
        public static String incompatibleCharacterSet;
        public static String languageFileCharacterSet;
        public static String no;
        public static String previewFile;
        public static String yes;

        static {
            Msgs.initializeMessages((String)BuildLanguagesAction.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

