/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor.internal;

import com.liferay.ide.portlet.core.model.Portlet;
import com.liferay.ide.portlet.ui.editor.internal.CreateLiferayPortletActionHandler;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.def.ActionHandlerFactoryDef;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodePart;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPagePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickActionsHandlerFactory
extends SapphireActionHandlerFactory {
    private String[] modelProperties;

    private static String getActionLabel(String labelText) {
        if (labelText.endsWith("s")) {
            labelText = labelText.substring(0, labelText.lastIndexOf("s"));
        }
        if (labelText.equals(Msgs.portlet)) {
            labelText = String.valueOf(labelText) + "...";
        }
        return labelText;
    }

    public List<SapphireActionHandler> create() {
        ArrayList<SapphireActionHandler> listOfHandlers = new ArrayList<SapphireActionHandler>();
        int i = 0;
        while (i < this.modelProperties.length) {
            String Property2 = this.modelProperties[i];
            if (Property2 != null && "Portlets".equalsIgnoreCase(Property2) && this.isPartInLiferayProject()) {
                CreateLiferayPortletActionHandler handler = new CreateLiferayPortletActionHandler();
                handler.init(this.getAction(), null);
                handler.addImage(Portlet.TYPE.image());
                handler.setLabel(QuickActionsHandlerFactory.getActionLabel(Msgs.portlets));
                listOfHandlers.add(handler);
            } else {
                listOfHandlers.add(new Handler(Property2));
            }
            ++i;
        }
        return listOfHandlers;
    }

    public void init(SapphireAction action, ActionHandlerFactoryDef def) {
        super.init(action, def);
        String strModelElementNames = def.getParam("MODEL_PROPERTIES");
        if (strModelElementNames == null) {
            throw new IllegalStateException(NLS.bind((String)Msgs.message, (Object)"MODEL_PROPERTIES"));
        }
        this.modelProperties = strModelElementNames.split(",");
    }

    private boolean isPartInLiferayProject() {
        SapphireEditor editor = (SapphireEditor)this.getPart().nearest(SapphireEditor.class);
        return editor != null && ProjectUtil.isLiferayFacetedProject((IProject)editor.getProject());
    }

    private static final class Handler
    extends SapphireActionHandler {
        private final String strProperty;

        public Handler(String Property) {
            this.strProperty = Property;
        }

        public void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            Element rootModel = action.getPart().getModelElement();
            PropertyDef _property = rootModel.type().property(this.strProperty);
            String labelText = _property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true);
            String actionLabel = QuickActionsHandlerFactory.getActionLabel(labelText);
            this.setLabel(actionLabel);
            ElementType propModelElementType = _property.getType();
            this.addImage(propModelElementType.image());
        }

        protected Object run(Presentation context) {
            Element rootModel = context.part().getModelElement();
            PropertyDef _property = rootModel.type().property(this.strProperty);
            Property obj = rootModel.property(_property);
            Element mElement = null;
            if (!(obj instanceof ElementList)) {
                throw new UnsupportedOperationException(Msgs.bind((String)Msgs.unsuportedOperation, (Object)this.strProperty));
            }
            ElementList list = (ElementList)obj;
            mElement = list.insert();
            MasterDetailsEditorPagePart page = (MasterDetailsEditorPagePart)this.getPart().nearest(MasterDetailsEditorPagePart.class);
            MasterDetailsContentNodePart root = page.outline().getRoot();
            MasterDetailsContentNodePart node = root.findNode(mElement);
            if (node != null) {
                node.select();
            }
            return mElement;
        }
    }

    private static class Msgs
    extends NLS {
        public static String message;
        public static String portlet;
        public static String portlets;
        public static String unsuportedOperation;

        static {
            Msgs.initializeMessages((String)QuickActionsHandlerFactory.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

