/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.AbstractPortletFramework;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.PluginPackageResourceListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleContext;

public class LiferayProjectCore
extends LiferayCore {
    public static final String LIFERAY_PROJECT_MARKR_TYPE = "com.liferay.ide.project.core.LiferayProjectMarker";
    private static LiferayProjectCore plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.project.core";
    private static PluginPackageResourceListener pluginPackageResourceListener;
    private static IPortletFramework[] portletFrameworks;
    public static final String PREF_DEFAULT_PROJECT_BUILD_TYPE_OPTION = "project-default-build-type-option";
    public static final String PREF_USE_SNAPSHOT_VERSION = "use-snapshot-version";
    public static final String USE_PROJECT_SETTINGS = "use-project-settings";
    public static final String VALUE_PROJECT_ANT_BUILD_TYPE = "ant";
    public static final String VALUE_PROJECT_MAVEN_BUILD_TYPE = "maven";

    public static LiferayProjectCore getDefault() {
        return plugin;
    }

    public static IPortletFramework getPortletFramework(String name) {
        IPortletFramework[] iPortletFrameworkArray = LiferayProjectCore.getPortletFrameworks();
        int n = iPortletFrameworkArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPortletFramework framework = iPortletFrameworkArray[n2];
            if (framework.getShortName().equals(name)) {
                return framework;
            }
            ++n2;
        }
        return null;
    }

    public static synchronized IPortletFramework[] getPortletFrameworks() {
        Object[] elements;
        if (portletFrameworks == null && !CoreUtil.isNullOrEmpty((Object[])(elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.liferay.ide.project.core.portletFrameworks")))) {
            ArrayList<AbstractPortletFramework> frameworks = new ArrayList<AbstractPortletFramework>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                String id = element.getAttribute("id");
                String shortName = element.getAttribute("shortName");
                String displayName = element.getAttribute("displayName");
                String description = element.getAttribute("description");
                String requiredSDKVersion = element.getAttribute("requiredSDKVersion");
                boolean isDefault = Boolean.parseBoolean(element.getAttribute("default"));
                boolean isAdvanced = Boolean.parseBoolean(element.getAttribute("advanced"));
                boolean isRequiresAdvanced = Boolean.parseBoolean(element.getAttribute("requiresAdvanced"));
                URL helpUrl = null;
                try {
                    helpUrl = new URL(element.getAttribute("helpUrl"));
                }
                catch (Exception exception) {}
                try {
                    AbstractPortletFramework framework = (AbstractPortletFramework)element.createExecutableExtension("class");
                    framework.setId(id);
                    framework.setShortName(shortName);
                    framework.setDisplayName(displayName);
                    framework.setDescription(description);
                    framework.setRequiredSDKVersion(requiredSDKVersion);
                    framework.setHelpUrl(helpUrl);
                    framework.setDefault(isDefault);
                    framework.setAdvanced(isAdvanced);
                    framework.setRequiresAdvanced(isRequiresAdvanced);
                    framework.setBundleId(element.getContributor().getName());
                    frameworks.add(framework);
                }
                catch (Exception e) {
                    LiferayProjectCore.logError("Could not create portlet framework.", e);
                }
                ++n2;
            }
            portletFrameworks = frameworks.toArray(new IPortletFramework[0]);
            Arrays.sort(portletFrameworks, 0, portletFrameworks.length, new Comparator<IPortletFramework>(){

                @Override
                public int compare(IPortletFramework o1, IPortletFramework o2) {
                    if (o1.isDefault() && !o2.isDefault()) {
                        return -1;
                    }
                    if (!o1.isDefault() && o2.isDefault()) {
                        return 1;
                    }
                    return o1.getShortName().compareTo(o2.getShortName());
                }
            });
        }
        return portletFrameworks;
    }

    public static void logError(String msg, Exception e) {
        LiferayProjectCore.getDefault().getLog().log(LiferayProjectCore.createErrorStatus((String)PLUGIN_ID, (String)msg, (Throwable)e));
    }

    public LiferayProjectCore() {
        pluginPackageResourceListener = new PluginPackageResourceListener();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)pluginPackageResourceListener, 1);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (pluginPackageResourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)pluginPackageResourceListener);
        }
    }

    public static /* bridge */ /* synthetic */ LiferayCore getDefault() {
        return LiferayProjectCore.getDefault();
    }
}

