/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.project.core.ISDKProjectsImportDataModelProperties;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class SDKProjectsImportOperation
extends AbstractDataModelOperation
implements ISDKProjectsImportDataModelProperties {
    public SDKProjectsImportOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        final String sdkLocation = this.model.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
        final IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        final Object[] projects = (Object[])this.model.getProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
        WorkspaceJob workspaceJob = new WorkspaceJob(Msgs.creatingSDKProjects){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    ProjectImportUtil.createWorkspaceProjects(projects, runtime, sdkLocation, monitor);
                }
                catch (Exception ex) {
                    return LiferayProjectCore.createErrorStatus((Exception)ex);
                }
                return Status.OK_STATUS;
            }
        };
        workspaceJob.setUser(true);
        workspaceJob.schedule();
        return Status.OK_STATUS;
    }

    private static class Msgs
    extends NLS {
        public static String creatingSDKProjects;

        static {
            Msgs.initializeMessages((String)SDKProjectsImportOperation.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

