/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.core.ILiferayProjectProvider;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleValuesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayVersionPossibleValuesService
extends PossibleValuesService {
    private List<String> versions = null;
    private Job versionsJob = null;
    private String groupId;
    private String artifactId;

    protected void init() {
        super.init();
        this.groupId = this.param("groupId");
        this.artifactId = this.param("artifactId");
    }

    protected void fillPossibleValues(Set<String> values) {
        if (this.versions != null) {
            values.addAll(this.versions);
        } else if (this.versionsJob == null) {
            this.versionsJob = new Job("Determining possible Liferay versions."){

                protected IStatus run(IProgressMonitor monitor) {
                    NewLiferayPluginProjectOp op = LiferayVersionPossibleValuesService.this.op();
                    if (!op.disposed()) {
                        ILiferayProjectProvider projectProvider = (ILiferayProjectProvider)op.getProjectProvider().content();
                        try {
                            LiferayVersionPossibleValuesService.this.versions = projectProvider.getData("liferayVersions", String.class, new Object[]{LiferayVersionPossibleValuesService.this.groupId, LiferayVersionPossibleValuesService.this.artifactId});
                        }
                        catch (Exception e) {
                            LiferayProjectCore.logError("Could not determine possible versions.", e);
                        }
                        LiferayVersionPossibleValuesService.this.broadcast();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.versionsJob.schedule();
        }
    }

    private NewLiferayPluginProjectOp op() {
        return (NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class);
    }

    public boolean ordered() {
        return true;
    }

    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return Status.Severity.OK;
    }
}

