/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import com.liferay.ide.project.core.model.NewLiferayProfile;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;

public class NewLiferayProfileIdDefaultValueService
extends DefaultValueService {
    private static final Pattern DUP = Pattern.compile("(.*)\\(([0-9]+)\\)$");

    protected void initDefaultValueService() {
        super.initDefaultValueService();
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                NewLiferayProfileIdDefaultValueService.this.refresh();
            }
        };
        this.newLiferayProfile().getRuntimeName().attach((Listener)listener);
    }

    protected DefaultValueServiceData compute() {
        NewLiferayProfile newLiferayProfile = this.newLiferayProfile();
        String defaultRuntimeName = (String)newLiferayProfile.getRuntimeName().content();
        String data = defaultRuntimeName;
        if (data.equals("<None>")) {
            return new DefaultValueServiceData("");
        }
        data = data.replaceAll(" ", "-");
        Set<String> possibleValues = NewLiferayPluginProjectOpMethods.getPossibleProfileIds((NewLiferayPluginProjectOp)newLiferayProfile.nearest(NewLiferayPluginProjectOp.class), false);
        while (possibleValues.contains(data)) {
            try {
                data = this.nextSuffix(data);
            }
            catch (Exception exception) {}
        }
        return new DefaultValueServiceData(data);
    }

    private String nextSuffix(String val) {
        Matcher matcher = DUP.matcher(val);
        if (matcher.matches()) {
            int num = Integer.parseInt(matcher.group(2));
            return String.valueOf(matcher.group(1)) + "(" + (num + 1) + ")";
        }
        return String.valueOf(val) + "(1)";
    }

    private NewLiferayProfile newLiferayProfile() {
        return (NewLiferayProfile)this.context(NewLiferayProfile.class);
    }
}

