/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.core.ILiferayProjectProvider;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.osgi.framework.Version;

public class PortletFrameworkValidationService
extends ValidationService {
    private FilteredListener<PropertyContentEvent> listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                PortletFrameworkValidationService.this.refresh();
            }
        };
        this.op().property(NewLiferayPluginProjectOp.PROP_PLUGINS_SDK_NAME).attach(this.listener);
        this.op().property(NewLiferayPluginProjectOp.PROP_PROJECT_PROVIDER).attach(this.listener);
    }

    protected Status compute() {
        Version sdkVersion;
        Version requiredVersion;
        SDK sdk;
        Status retval = Status.createOkStatus();
        ILiferayProjectProvider projectProvider = (ILiferayProjectProvider)this.op().getProjectProvider().content();
        IPortletFramework portletFramework = (IPortletFramework)this.op().getPortletFramework().content();
        if (!portletFramework.supports(projectProvider)) {
            retval = Status.createErrorStatus((String)("Selected portlet framework is not supported with " + projectProvider.getDisplayName()));
        } else {
            sdk = SDKManager.getInstance().getSDK((String)this.op().getPluginsSDKName().content());
            if ("ant".equals(projectProvider.getShortName()) && portletFramework != null && sdk != null && CoreUtil.compareVersions((Version)(requiredVersion = new Version(portletFramework.getRequiredSDKVersion())), (Version)(sdkVersion = new Version(sdk.getVersion()))) > 0) {
                retval = Status.createErrorStatus((String)("Selected portlet framework requires SDK version at least " + requiredVersion));
            }
        }
        sdk = SDKManager.getInstance().getSDK((String)this.op().getPluginsSDKName().content());
        if ("ant".equals(projectProvider.getShortName()) && portletFramework != null && sdk != null && CoreUtil.compareVersions((Version)(requiredVersion = new Version(portletFramework.getRequiredSDKVersion())), (Version)(sdkVersion = new Version(sdk.getVersion()))) > 0) {
            retval = Status.createErrorStatus((String)("Selected portlet framework requires SDK version at least " + requiredVersion));
        }
        return retval;
    }

    public void dispose() {
        this.op().property(NewLiferayPluginProjectOp.PROP_PLUGINS_SDK_NAME).detach(this.listener);
        this.op().property(NewLiferayPluginProjectOp.PROP_PROJECT_PROVIDER).detach(this.listener);
        super.dispose();
    }

    private NewLiferayPluginProjectOp op() {
        return (NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class);
    }
}

