/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import com.liferay.ide.core.util.ZipUtil;
import com.liferay.ide.project.core.BinaryProjectRecord;
import com.liferay.ide.project.core.IPortletFramework;
import com.liferay.ide.project.core.LiferayProjectCore;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.sdk.core.ISDKConstants;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectImportUtil {
    public static boolean collectBinariesFromDirectory(Collection<File> binaryProjectFiles, File directory, boolean recurse, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)Msgs.checking, (Object)directory.getPath()));
        List<String> wildCards = Arrays.asList(ISDKConstants.BINARY_PLUGIN_PROJECT_WILDCARDS);
        WildcardFileFilter wildcardFileFilter = new WildcardFileFilter(wildCards);
        Collection contents = FileUtils.listFiles((File)directory, (IOFileFilter)wildcardFileFilter, (IOFileFilter)DirectoryFileFilter.INSTANCE);
        if (contents == null) {
            return false;
        }
        for (File file : contents) {
            if (binaryProjectFiles.contains(file) || !ProjectImportUtil.isValidLiferayPlugin(file)) continue;
            binaryProjectFiles.add(file);
        }
        return true;
    }

    public static ProjectRecord createSDKPluginProject(BridgedRuntime bridgedRuntime, BinaryProjectRecord pluginBinaryRecord, SDK liferaySDK) throws IOException {
        ProjectRecord projectRecord = null;
        if (!pluginBinaryRecord.isConflicts()) {
            String displayName = pluginBinaryRecord.getDisplayName();
            String liferayPluginName = pluginBinaryRecord.getLiferayPluginName();
            File binaryFile = pluginBinaryRecord.getBinaryFile();
            IPath projectPath = null;
            IPath sdkPluginProjectFolder = liferaySDK.getLocation();
            ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((BridgedRuntime)bridgedRuntime);
            Map appServerProperties = ServerUtil.getSDKRequiredProperties((ILiferayRuntime)liferayRuntime);
            String webappRootFolder = null;
            NullProgressMonitor npm = new NullProgressMonitor();
            if (pluginBinaryRecord.isHook()) {
                sdkPluginProjectFolder = sdkPluginProjectFolder.append("hooks");
                projectPath = liferaySDK.createNewHookProject(displayName, displayName, true, sdkPluginProjectFolder.toOSString(), sdkPluginProjectFolder.toOSString(), (IProgressMonitor)npm);
                webappRootFolder = "docroot";
            } else if (pluginBinaryRecord.isPortlet()) {
                IPortletFramework[] portletFrameworks = LiferayProjectCore.getPortletFrameworks();
                String portletFrameworkName = null;
                int i = 0;
                while (i < portletFrameworks.length) {
                    IPortletFramework portletFramework = portletFrameworks[i];
                    if (portletFramework.isDefault() && !portletFramework.isAdvanced()) {
                        portletFrameworkName = portletFramework.getShortName();
                        break;
                    }
                    ++i;
                }
                sdkPluginProjectFolder = sdkPluginProjectFolder.append("portlets");
                projectPath = liferaySDK.createNewPortletProject(displayName, displayName, portletFrameworkName, appServerProperties, true, sdkPluginProjectFolder.toOSString(), sdkPluginProjectFolder.toOSString(), (IProgressMonitor)npm);
                webappRootFolder = "docroot";
            } else if (pluginBinaryRecord.isTheme()) {
                sdkPluginProjectFolder = sdkPluginProjectFolder.append("themes");
                projectPath = liferaySDK.createNewThemeProject(displayName, displayName, true, sdkPluginProjectFolder.toOSString(), sdkPluginProjectFolder.toOSString(), (IProgressMonitor)npm);
                webappRootFolder = "docroot";
            } else if (pluginBinaryRecord.isLayoutTpl()) {
                sdkPluginProjectFolder = sdkPluginProjectFolder.append("layouttpl");
                projectPath = liferaySDK.createNewLayoutTplProject(displayName, displayName, appServerProperties, true, sdkPluginProjectFolder.toOSString(), sdkPluginProjectFolder.toOSString(), (IProgressMonitor)npm);
                webappRootFolder = "docroot";
            } else if (pluginBinaryRecord.isExt()) {
                sdkPluginProjectFolder = sdkPluginProjectFolder.append("ext");
                projectPath = liferaySDK.createNewExtProject(displayName, displayName, appServerProperties, true, sdkPluginProjectFolder.toOSString(), sdkPluginProjectFolder.toOSString(), (IProgressMonitor)npm);
                webappRootFolder = "docroot/WEB-INF/ext-web/docroot";
            }
            File tempProjectDir = projectPath.append(liferayPluginName).toFile();
            File liferayPluginDir = sdkPluginProjectFolder.toFile();
            File liferayPluginProjectDir = new File(liferayPluginDir, liferayPluginName);
            FileUtils.copyDirectory((File)tempProjectDir, (File)liferayPluginProjectDir);
            File webappRoot = new File(liferayPluginProjectDir, webappRootFolder);
            ZipUtil.unzip((File)binaryFile, (File)webappRoot);
            File projectFile = new File(liferayPluginProjectDir, ".project");
            projectRecord = projectFile.exists() ? new ProjectRecord(projectFile) : new ProjectRecord(liferayPluginProjectDir);
        }
        return projectRecord;
    }

    public static void createWorkspaceProjects(Object[] projects, IRuntime runtime, String sdkLocation, IProgressMonitor monitor) throws CoreException {
        ArrayList<IProject> createdProjects = new ArrayList<IProject>();
        monitor.beginTask(Msgs.creatingSDKWorkspaceProjects, projects.length);
        if (projects != null && projects.length > 0) {
            SDK sdk = SDKManager.getInstance().getSDK((IPath)new Path(sdkLocation));
            if (sdk == null) {
                sdk = SDKUtil.createSDKFromLocation((IPath)new Path(sdkLocation));
            }
            if (sdk != null && sdk.isValid() && !SDKManager.getInstance().containsSDK(sdk)) {
                SDKManager.getInstance().addSDK(sdk);
            }
        }
        int i = 0;
        while (i < projects.length) {
            IProject project;
            if (projects[i] instanceof ProjectRecord && (project = ProjectUtil.importProject((ProjectRecord)projects[i], runtime, sdkLocation, monitor)) != null) {
                createdProjects.add(project);
                monitor.worked(createdProjects.size());
            }
            ++i;
        }
    }

    public static final String getConfigFileLocation(String configFile) {
        StringBuilder sb = new StringBuilder("WEB-INF/");
        sb.append(configFile);
        return sb.toString();
    }

    public static boolean isValidLiferayPlugin(File binaryFile) {
        boolean isValid = false;
        try {
            JarFile pluginBinary = new JarFile(binaryFile);
            BinaryProjectRecord tempRecord = new BinaryProjectRecord(binaryFile);
            JarEntry lfrPluginPkgPropsEntry = pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-plugin-package.properties"));
            JarEntry lfrPluginPkgXmlEntry = pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-plugin-package.xml"));
            if (lfrPluginPkgPropsEntry != null || lfrPluginPkgXmlEntry != null) {
                isValid = true;
            }
            if (tempRecord.isHook()) {
                isValid = isValid && pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-hook.xml")) != null;
            } else if (tempRecord.isLayoutTpl()) {
                isValid = isValid || pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-layout-templates.xml")) != null;
            } else if (tempRecord.isPortlet()) {
                isValid = isValid && pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-portlet.xml")) != null;
            } else if (tempRecord.isTheme()) {
                boolean bl = isValid = isValid || pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("liferay-look-and-feel.xml")) != null;
            }
            if (!isValid) {
                return isValid;
            }
            isValid = isValid || pluginBinary.getJarEntry(ProjectImportUtil.getConfigFileLocation("web.xml")) != null;
        }
        catch (IOException iOException) {
            isValid = false;
        }
        return isValid;
    }

    private static class Msgs
    extends NLS {
        public static String checking;
        public static String creatingSDKWorkspaceProjects;

        static {
            Msgs.initializeMessages((String)ProjectImportUtil.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

