/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.ui;

import com.liferay.ide.core.adapter.LaunchAdapter;
import com.liferay.ide.maven.core.LiferayMavenProject;
import com.liferay.ide.maven.core.MavenProjectBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class MavenUIProjectBuilder
extends MavenProjectBuilder {
    public MavenUIProjectBuilder(IProject project) {
        super(project);
    }

    public MavenUIProjectBuilder(LiferayMavenProject liferayMavenProject) {
        super(liferayMavenProject.getProject());
    }

    public IStatus buildLang(IFile langFile, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
        sub.beginTask(MavenProjectBuilder.Msgs.buildingLanguages, 100);
        IFile pomFile = this.getProject().getFile((IPath)new Path("pom.xml"));
        IMavenProjectFacade projectFacade = this.projectManager.create(pomFile, false, (IProgressMonitor)new NullProgressMonitor());
        sub.worked(10);
        IStatus retval = this.runMavenGoal(projectFacade, "liferay:build-lang", "run", monitor);
        sub.done();
        return retval;
    }

    public IStatus buildSB(IFile serviceXmlFile, String goal, IProgressMonitor monitor) throws CoreException {
        IFile pomFile = this.getProject().getFile((IPath)new Path("pom.xml"));
        IMavenProjectFacade projectFacade = this.projectManager.create(pomFile, false, (IProgressMonitor)new NullProgressMonitor());
        monitor.worked(10);
        IStatus status = this.runMavenGoal(projectFacade, goal, "run", monitor);
        this.refreshSiblingProject(projectFacade, monitor);
        monitor.worked(10);
        monitor.done();
        return status;
    }

    public IStatus buildService(IFile serviceXmlFile, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
        sub.beginTask(MavenProjectBuilder.Msgs.buildingServices, 100);
        return this.buildSB(serviceXmlFile, "liferay:build-service", (IProgressMonitor)sub);
    }

    public IStatus buildWSDD(IFile serviceXmlFile, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
        sub.beginTask(MavenProjectBuilder.Msgs.buildingWSDD, 100);
        return this.buildSB(serviceXmlFile, "liferay:build-wsdd", (IProgressMonitor)sub);
    }

    public IStatus runMavenGoal(IMavenProjectFacade projectFacade, String goal, final String mode, IProgressMonitor monitor) throws CoreException {
        IStatus retval = Status.OK_STATUS;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.m2e.Maven2LaunchConfigurationType");
        IPath basedirLocation = this.getProject().getLocation();
        String newName = launchManager.generateLaunchConfigurationName(basedirLocation.lastSegment());
        final ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, newName);
        workingCopy.setAttribute(MavenLaunchConstants.ATTR_POM_DIR, basedirLocation.toString());
        workingCopy.setAttribute("M2_GOALS", goal);
        workingCopy.setAttribute("M2_UPDATE_SNAPSHOTS", true);
        workingCopy.setAttribute("M2_WORKSPACE_RESOLUTION", true);
        workingCopy.setAttribute("M2_SKIP_TESTS", true);
        if (projectFacade != null) {
            ILaunchListener[] listener;
            ResolverConfiguration configuration = projectFacade.getResolverConfiguration();
            String selectedProfiles = configuration.getSelectedProfiles();
            if (selectedProfiles != null && selectedProfiles.length() > 0) {
                workingCopy.setAttribute("M2_PROFILES", selectedProfiles);
            }
            UIJob launchJob = new UIJob("maven launch"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DebugUITools.launch((ILaunchConfiguration)workingCopy, (String)mode);
                    return Status.OK_STATUS;
                }
            };
            final boolean[] launchTerminated = new boolean[1];
            listener = new ILaunchListener[]{new LaunchAdapter(){

                public void launchChanged(final ILaunch launch) {
                    if (launch.getLaunchConfiguration().equals(workingCopy)) {
                        Thread t = new Thread(){

                            public void run() {
                                while (launch.getProcesses().length > 0 && !launch.getProcesses()[0].isTerminated()) {
                                    try {
                                        1.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                launchTerminated[0] = true;
                                DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(listener[0]);
                            }
                        };
                        t.start();
                    }
                }
            }};
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener(listener[0]);
            launchJob.schedule();
            while (Display.getCurrent() == null && !launchTerminated[0]) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return retval;
    }
}

