/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.ui;

import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.maven.ui.AbstractProjectMarkerResolution;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayProfile;
import com.liferay.ide.project.ui.action.NewLiferayProfileActionHandler;
import com.liferay.ide.project.ui.wizard.NewLiferayPluginProjectWizard;
import com.liferay.ide.ui.util.UIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class NewLiferayProfileMarkerResolution
extends AbstractProjectMarkerResolution {
    private String pluginVersion;

    public NewLiferayProfileMarkerResolution(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getLabel() {
        return "Create a new maven profile based on a Liferay runtime and attach it to the project.";
    }

    protected int promptUser(IProject project, NewLiferayPluginProjectOp op) {
        NewLiferayProfile newLiferayProfile = (NewLiferayProfile)op.getNewLiferayProfiles().insert();
        DefinitionLoader.Reference dialogRef = DefinitionLoader.sdef(NewLiferayPluginProjectWizard.class).dialog("NewLiferayProfile");
        SapphireDialog dialog = new SapphireDialog(UIUtil.getActiveShell(), (Element)newLiferayProfile, dialogRef);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            try {
                IFile pomFile = project.getFile("pom.xml");
                IDOMModel domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(pomFile);
                MavenUtil.createNewLiferayProfileNode((Document)domModel.getDocument(), (NewLiferayProfile)newLiferayProfile, (String)this.pluginVersion);
                domModel.save();
                domModel.releaseFromEdit();
            }
            catch (Exception e) {
                LiferayMavenCore.logError((String)"Unable to save new Liferay profiles to project pom.", (Throwable)e);
            }
            NewLiferayProfileActionHandler.addToActiveProfiles((NewLiferayPluginProjectOp)op, (NewLiferayProfile)newLiferayProfile);
        } else {
            op.getNewLiferayProfiles().remove((Object)newLiferayProfile);
        }
        return result;
    }
}

