/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.templates.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.templates.core.ITemplateContext;
import com.liferay.ide.templates.core.ITemplateOperation;
import com.liferay.ide.templates.core.TemplateContext;
import com.liferay.ide.templates.core.TemplateModel;
import com.liferay.ide.templates.core.TemplatesCore;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class TemplateOperation
implements ITemplateOperation {
    protected ITemplateContext context;
    protected TemplateModel model;
    protected StringBuffer outputBuffer;
    protected IFile outputFile;
    protected Template template;

    public TemplateOperation(TemplateModel model) {
        this.model = model;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canExecute() {
        try {
            if (this.outputFile == null && this.outputBuffer == null || this.model == null || this.getTemplate() == null) {
                return false;
            }
            Object[] names = this.model.getRequiredVarNames();
            if (!CoreUtil.isNullOrEmpty((Object[])names)) {
                Object[] objectArray = names;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    Object name = objectArray[n2];
                    if (!this.getContext().containsKey((String)name)) {
                        TemplatesCore.logError("Could not execute template operation: context var " + (String)name + " not found.");
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected TemplateContext createContext() {
        return new TemplateContext();
    }

    public void execute(IProgressMonitor monitor) throws Exception {
        if (!this.canExecute()) {
            return;
        }
        StringWriter writer = new StringWriter();
        TemplateContext templateContext = (TemplateContext)this.getContext();
        this.getTemplate().process(templateContext.getMap(), (Writer)writer);
        String result = writer.toString();
        if (this.outputFile != null) {
            if (this.outputFile.exists()) {
                this.outputFile.setContents((InputStream)new ByteArrayInputStream(result.getBytes()), true, true, monitor);
            } else {
                this.outputFile.create((InputStream)new ByteArrayInputStream(result.getBytes()), true, monitor);
            }
        } else if (this.outputBuffer != null) {
            this.outputBuffer.delete(0, this.outputBuffer.length());
            this.outputBuffer.append(result);
        }
    }

    public ITemplateContext getContext() {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    protected Template getTemplate() throws Exception {
        if (this.model == null) {
            return null;
        }
        if (this.template == null) {
            this.template = this.model.getConfig().getTemplate(this.model.getResource());
        }
        return this.template;
    }

    public void setOutputBuffer(StringBuffer buffer) {
        this.outputBuffer = buffer;
    }

    public void setOutputFile(IFile file) {
        this.outputFile = file;
    }
}

