/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IProfileListener1;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.enablement.jdt.classpath.DriverClasspathContainer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.db.ConnectionProfileListener;
import org.eclipse.jpt.jpa.db.DatabaseIdentifierAdapter;
import org.eclipse.jpt.jpa.db.internal.DTPConnectionProfileWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTPConnectionProfileFactory
implements ConnectionProfileFactory {
    private final IWorkspace workspace;
    private final ProfileManager dtpProfileManager;
    private final LocalProfileListener profileListener;
    public static final Transformer<IConnectionProfile, String> DTP_CONNECTION_PROFILE_NAME_TRANSFORMER = new DTPConnectionProfileNameTransformer();

    public DTPConnectionProfileFactory(IWorkspace workspace) {
        this.workspace = workspace;
        this.dtpProfileManager = ProfileManager.getInstance();
        this.profileListener = this.buildProfileListener();
        this.dtpProfileManager.addProfileListener((IProfileListener)this.profileListener);
    }

    @Override
    public synchronized ConnectionProfile buildConnectionProfile(String name, DatabaseIdentifierAdapter adapter) {
        IConnectionProfile[] iConnectionProfileArray = this.dtpProfileManager.getProfiles();
        int n = iConnectionProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile dtpProfile = iConnectionProfileArray[n2];
            if (dtpProfile.getName().equals(name)) {
                return this.buildConnectionProfile(dtpProfile, adapter);
            }
            ++n2;
        }
        return null;
    }

    private ConnectionProfile buildConnectionProfile(IConnectionProfile dtpProfile, DatabaseIdentifierAdapter adapter) {
        return new DTPConnectionProfileWrapper(dtpProfile, adapter);
    }

    @Override
    public ConnectionProfile buildConnectionProfile(String name) {
        return this.buildConnectionProfile(name, DatabaseIdentifierAdapter.Default.instance());
    }

    @Override
    public Iterable<String> getConnectionProfileNames() {
        return IterableTools.transform(this.getDTPConnectionProfiles(), DTP_CONNECTION_PROFILE_NAME_TRANSFORMER);
    }

    private synchronized Iterable<IConnectionProfile> getDTPConnectionProfiles() {
        return IterableTools.iterable((Object[])this.dtpProfileManager.getProfiles());
    }

    @Override
    public void addConnectionProfileListener(ConnectionProfileListener listener) {
        this.profileListener.addConnectionProfileListener(listener);
    }

    @Override
    public void removeConnectionProfileListener(ConnectionProfileListener listener) {
        this.profileListener.removeConnectionProfileListener(listener);
    }

    private LocalProfileListener buildProfileListener() {
        return new LocalProfileListener();
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public IClasspathContainer buildDriverClasspathContainer(String driverName) {
        return new DriverClasspathContainer(driverName);
    }

    public void dispose() {
        this.dtpProfileManager.removeProfileListener((IProfileListener)this.profileListener);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DTPConnectionProfileNameTransformer
    extends TransformerAdapter<IConnectionProfile, String> {
        public String transform(IConnectionProfile connectionProfile) {
            return connectionProfile.getName();
        }
    }

    private static class LocalProfileListener
    implements IProfileListener1 {
        private final ListenerList<ConnectionProfileListener> listenerList = new ListenerList(ConnectionProfileListener.class);

        LocalProfileListener() {
        }

        void addConnectionProfileListener(ConnectionProfileListener listener) {
            this.listenerList.add((Object)listener);
        }

        void removeConnectionProfileListener(ConnectionProfileListener listener) {
            this.listenerList.remove((Object)listener);
        }

        public void profileAdded(IConnectionProfile dtpProfile) {
            String name = dtpProfile.getName();
            for (ConnectionProfileListener listener : this.listenerList.getListeners()) {
                listener.connectionProfileAdded(name);
            }
        }

        public void profileChanged(IConnectionProfile dtpProfile, String oldName, String oldDescription, Boolean oldAutoConnect) {
            String newName = dtpProfile.getName();
            if (!newName.equals(oldName)) {
                for (ConnectionProfileListener listener : this.listenerList.getListeners()) {
                    listener.connectionProfileRenamed(oldName, newName);
                }
            }
        }

        public void profileChanged(IConnectionProfile dtpProfile) {
            throw new UnsupportedOperationException();
        }

        public void profileDeleted(IConnectionProfile dtpProfile) {
            String name = dtpProfile.getName();
            for (ConnectionProfileListener listener : this.listenerList.getListeners()) {
                listener.connectionProfileRemoved(name);
            }
        }
    }
}

