/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.core.model;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.layouttpl.core.model.ILayoutTplDiagramFactory;
import com.liferay.ide.layouttpl.core.model.ModelElement;
import com.liferay.ide.layouttpl.core.model.PortletLayoutElement;
import com.liferay.ide.layouttpl.core.model.PortletRowLayoutElement;
import com.liferay.ide.layouttpl.core.util.LayoutTplUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class PortletColumnElement
extends PortletRowLayoutElement {
    public static final int DEFAULT_WEIGHT = -1;
    public static final String WEIGHT_PROP = "PortletColumn.weight";
    protected String className;
    protected boolean first = false;
    protected boolean last = false;
    protected int numId = 0;
    protected int weight;

    public static PortletColumnElement createFromElement(IDOMElement portletColumnElement, ILayoutTplDiagramFactory factory) {
        if (portletColumnElement == null) {
            return null;
        }
        PortletColumnElement newPortletColumn = factory.newPortletColumn();
        String existingClassName = portletColumnElement.getAttribute("class");
        if (!CoreUtil.isNullOrEmpty((String)existingClassName) && existingClassName.contains("portlet-column")) {
            newPortletColumn.setClassName(existingClassName);
        } else {
            newPortletColumn.setClassName("portlet-column");
        }
        newPortletColumn.setWeight(LayoutTplUtil.getWeightValue(portletColumnElement, -1));
        Object[] portletLayoutElements = LayoutTplUtil.findChildElementsByClassName(portletColumnElement, "div", "portlet-layout");
        if (!CoreUtil.isNullOrEmpty((Object[])portletLayoutElements)) {
            Object[] objectArray = portletLayoutElements;
            int n = portletLayoutElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object portletLayoutElement = objectArray[n2];
                PortletLayoutElement newPortletLayout = factory.newPortletLayoutFromElement((IDOMElement)portletLayoutElement);
                newPortletColumn.addRow(newPortletLayout);
                ++n2;
            }
        }
        return newPortletColumn;
    }

    public PortletColumnElement() {
        this(-1, "portlet-column");
    }

    public PortletColumnElement(int weight) {
        this(weight, "portlet-column");
    }

    public PortletColumnElement(int weight, String className) {
        this.weight = weight;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public int getNumId() {
        return this.numId;
    }

    public Object getPropertyValue(Object propertyId) {
        if (WEIGHT_PROP.equals(propertyId)) {
            if (this.getWeight() == -1) {
                return "100%";
            }
            return String.valueOf(Integer.toString(this.getWeight())) + "%";
        }
        return super.getPropertyValue(propertyId);
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isLast() {
        return this.last;
    }

    public void removeChild(ModelElement child) {
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public void setNumId(int numId) {
        this.numId = numId;
    }

    public void setPropertyValue(Object propertyId, Object value) {
        if (WEIGHT_PROP.equals(propertyId)) {
            String val = value.toString().replaceAll("%", "");
            int weight = Integer.parseInt(val);
            this.setWeight(weight);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    public void setWeight(int weight) {
        int oldValue = this.weight;
        this.weight = weight;
        this.firePropertyChange(WEIGHT_PROP, oldValue, this.weight);
    }
}

