/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.vaadin.core.dd;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.DescriptorHelper;
import com.liferay.ide.core.util.NodeUtil;
import com.liferay.ide.portlet.core.PluginPropertiesConfiguration;
import com.liferay.ide.portlet.core.dd.PortletDescriptorHelper;
import com.liferay.ide.portlet.vaadin.core.VaadinCore;
import com.liferay.ide.portlet.vaadin.core.operation.INewVaadinPortletClassDataModelProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.osgi.framework.Version;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VaadinPortletDescriptorHelper
extends PortletDescriptorHelper
implements INewVaadinPortletClassDataModelProperties {
    public VaadinPortletDescriptorHelper(IProject project) {
        super(project);
    }

    public IStatus addNewPortlet(IDataModel model) {
        DescriptorHelper.DOMModelEditOperation op;
        IStatus opStatus;
        IFile descriptorFile;
        Version runtimeVersion;
        IStatus status = super.addNewPortlet(model);
        if (!status.isOK()) {
            return status;
        }
        ILiferayProject liferayProject = LiferayCore.create((Object)this.project);
        if (liferayProject != null && liferayProject.getPortalVersion() != null && CoreUtil.compareVersions((Version)(runtimeVersion = new Version(liferayProject.getPortalVersion())), (Version)ILiferayConstants.V620) >= 0 && (descriptorFile = this.getDescriptorFile("liferay-portlet.xml")) != null && !(opStatus = (op = new DescriptorHelper.DOMModelEditOperation((DescriptorHelper)this, descriptorFile){

            protected void createDefaultFile() {
            }

            protected IStatus doExecute(IDOMDocument document) {
                return VaadinPortletDescriptorHelper.this.updateVaadinLiferayPortletXML(document);
            }
        }).execute()).isOK()) {
            return opStatus;
        }
        return this.addPortalDependency("portal-dependency-jars", "vaadin.jar");
    }

    private IStatus updateVaadinLiferayPortletXML(IDOMDocument document) {
        Element rootElement = document.getDocumentElement();
        NodeList portletNodes = rootElement.getElementsByTagName("portlet");
        if (portletNodes.getLength() > 1) {
            Element lastPortletElement = (Element)portletNodes.item(portletNodes.getLength() - 1);
            Element rnpNode = NodeUtil.appendChildElement((Element)lastPortletElement, (String)"requires-namespaced-parameters", (String)"false");
            Element ajaxNode = NodeUtil.appendChildElement((Element)lastPortletElement, (String)"ajaxable", (String)"false");
            Node hpcNode = lastPortletElement.getElementsByTagName("header-portlet-css").item(0);
            Node fpjNode = lastPortletElement.getElementsByTagName("footer-portlet-javascript").item(0);
            lastPortletElement.replaceChild(rnpNode, hpcNode);
            lastPortletElement.replaceChild(ajaxNode, fpjNode);
        }
        return Status.OK_STATUS;
    }

    public IStatus addPortalDependency(String propertyName, String value) {
        if (CoreUtil.isNullOrEmpty((String)value)) {
            return Status.OK_STATUS;
        }
        try {
            String[] existingValues;
            IVirtualComponent comp = ComponentCore.createComponent((IProject)this.project.getProject());
            if (comp == null) {
                IStatus warning = VaadinCore.createWarningStatus("Could not add Vaadin dependency to the project.");
                VaadinCore.getDefault().getLog().log(warning);
                return Status.OK_STATUS;
            }
            IFolder webroot = (IFolder)comp.getRootFolder().getUnderlyingFolder();
            IFile pluginPackageFile = webroot.getFile("WEB-INF/liferay-plugin-package.properties");
            if (!pluginPackageFile.exists()) {
                IStatus warning = VaadinCore.createWarningStatus("No liferay-plugin-package.properties file in the project, not adding Vaadin dependency.");
                VaadinCore.getDefault().getLog().log(warning);
                return Status.OK_STATUS;
            }
            File osfile = new File(pluginPackageFile.getLocation().toOSString());
            PluginPropertiesConfiguration pluginPackageProperties = new PluginPropertiesConfiguration();
            pluginPackageProperties.load(osfile);
            String existingDeps = pluginPackageProperties.getString(propertyName, "");
            String[] stringArray = existingValues = existingDeps.split(",");
            int n = existingValues.length;
            int n2 = 0;
            while (n2 < n) {
                String existingValue = stringArray[n2];
                if (value.equals(existingValue)) {
                    return Status.OK_STATUS;
                }
                ++n2;
            }
            String newPortalDeps = null;
            newPortalDeps = CoreUtil.isNullOrEmpty((String)existingDeps) ? value : String.valueOf(existingDeps) + "," + value;
            pluginPackageProperties.setProperty(propertyName, (Object)newPortalDeps);
            FileWriter output = new FileWriter(osfile);
            try {
                pluginPackageProperties.save((Writer)output);
            }
            finally {
                output.close();
            }
            pluginPackageFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            VaadinCore.logError(e);
            return VaadinCore.createErrorStatus("Could not add dependency to vaadin.jar in liferay-plugin-package.properties .");
        }
        return Status.OK_STATUS;
    }

    protected String getPortletClassText(IDataModel model) {
        return model.getStringProperty("INewVaadinPortletClassDataModelProperties.VAADIN_PORTLET_CLASS");
    }
}

