/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.snippets.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.model.SnippetManager;
import org.eclipse.wst.common.snippets.internal.palette.ModelFactoryForUser;

public class SnippetsUtil {
    public static IViewPart findSnippetsView() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IViewPart snippetsView = page.findView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
                if (snippetsView != null) {
                    return snippetsView;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static void importSnippetsFromFile(File snippetFile) throws FileNotFoundException {
        if (snippetFile == null || !snippetFile.exists() || !snippetFile.isFile()) {
            return;
        }
        SnippetDefinitions definitions = ModelFactoryForUser.getInstance().load(snippetFile.getAbsolutePath());
        final List importCategories = definitions.getCategories();
        final List currentCategories = SnippetManager.getInstance().getDefinitions().getCategories();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                int i = 0;
                while (i < importCategories.size()) {
                    boolean found = false;
                    int j = 0;
                    while (j < currentCategories.size()) {
                        if (((PaletteEntry)currentCategories.get(j)).getId().compareToIgnoreCase(((PaletteEntry)importCategories.get(i)).getId()) == 0) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        SnippetManager.getInstance().getPaletteRoot().add((PaletteEntry)importCategories.get(i));
                    }
                    ++i;
                }
            }
        });
    }
}

