/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.schema;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.xml.schema.XmlChoiceGroup;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModelReference;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinitionByReference;
import org.eclipse.sapphire.modeling.xml.schema.XmlGroupContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class XmlDocumentSchemaParser {
    @Text(value="Failed while parsing XML Schema located at \"{0}\".")
    private static LocalizableText parseFailed;

    static {
        LocalizableText.init(XmlDocumentSchemaParser.class);
    }

    public static XmlDocumentSchema parse(URL url, Resolver resolver) {
        return XmlDocumentSchemaParser.parse(url, url.toString(), resolver);
    }

    public static XmlDocumentSchema parse(URL url, String location, Resolver resolver) {
        XmlDocumentSchema.Factory schema = new XmlDocumentSchema.Factory();
        schema.setSchemaLocation(location);
        XmlDocumentSchemaParser.parse(schema, url, resolver);
        return schema.create();
    }

    private static void parse(XmlDocumentSchema.Factory schema, URL url, Resolver resolver) {
        Element root = XmlDocumentSchemaParser.parseSchemaToDom(url);
        if (root != null) {
            String elname;
            HashMap<String, String> prefixToNamespaceMap = new HashMap<String, String>();
            String ns = schema.getNamespace();
            if (ns == null && (ns = root.getAttribute("targetNamespace")).length() > 0) {
                schema.setNamespace(ns);
            }
            NamedNodeMap rootAttributes = root.getAttributes();
            int i = 0;
            int n = rootAttributes.getLength();
            while (i < n) {
                Node attributeNode = rootAttributes.item(i);
                String attributeNodeName = attributeNode.getNodeName();
                String attributeNodeValue = ((Attr)attributeNode).getValue();
                if (attributeNodeName.equals("xmlns")) {
                    prefixToNamespaceMap.put("", attributeNodeValue);
                } else if (attributeNodeName.startsWith("xmlns:")) {
                    prefixToNamespaceMap.put(attributeNodeName.substring(6), attributeNodeValue);
                }
                ++i;
            }
            if (!prefixToNamespaceMap.containsValue(ns)) {
                prefixToNamespaceMap.put("", ns);
            }
            for (Element el : XmlDocumentSchemaParser.elements(root)) {
                elname = el.getLocalName();
                if (elname.equals("import")) {
                    String importedNamespace = el.getAttribute("namespace");
                    String importedSchemaLocation = el.getAttribute("schemaLocation");
                    schema.addImportedNamespace(importedNamespace, importedSchemaLocation);
                    continue;
                }
                if (!elname.equals("include") && !elname.equals("redefine")) continue;
                String includedSchemaLocation = el.getAttribute("schemaLocation").trim();
                if (!includedSchemaLocation.startsWith("http://")) {
                    String location = url.toString();
                    int lastSlash = location.lastIndexOf(47);
                    String baseUrl = lastSlash == -1 ? location : location.substring(0, lastSlash);
                    includedSchemaLocation = String.valueOf(baseUrl) + "/" + includedSchemaLocation;
                }
                XmlDocumentSchemaParser.parse(schema, resolver.resolve(includedSchemaLocation), resolver);
                if (!elname.equals("redefine")) continue;
                for (Element child : XmlDocumentSchemaParser.elements(el)) {
                    if (!child.getLocalName().equals("complexType")) continue;
                    String name = child.getAttribute("name");
                    XmlContentModel.Factory contentModel = XmlDocumentSchemaParser.parseContentModel(schema, prefixToNamespaceMap, child);
                    if (contentModel == null) continue;
                    contentModel = XmlDocumentSchemaParser.inlineContentModelReference(schema, contentModel, name);
                    schema.addContentModel(name, contentModel);
                }
            }
            for (Element el : XmlDocumentSchemaParser.elements(root)) {
                elname = el.getLocalName();
                if (elname.equals("complexType") || elname.equals("group")) {
                    String name = el.getAttribute("name");
                    XmlContentModel.Factory contentModel = XmlDocumentSchemaParser.parseContentModel(schema, prefixToNamespaceMap, el);
                    if (contentModel == null) continue;
                    schema.addContentModel(name, contentModel);
                    continue;
                }
                if (!elname.equals("element")) continue;
                XmlElementDefinition.Factory xmlElementDefinition = XmlDocumentSchemaParser.parseElement(schema, prefixToNamespaceMap, el);
                schema.addTopLevelElement(xmlElementDefinition);
            }
        }
    }

    private static XmlContentModel.Factory parseContentModel(XmlDocumentSchema.Factory schema, Map<String, String> prefixToNamespaceMap, Element el) {
        String elname = el.getLocalName();
        if (elname.equals("complexType") || elname.equals("complexContent")) {
            XmlContentModel.Factory contentModel = null;
            for (Element x : XmlDocumentSchemaParser.elements(el)) {
                contentModel = XmlDocumentSchemaParser.parseContentModel(schema, prefixToNamespaceMap, x);
                if (contentModel == null) continue;
                return contentModel;
            }
            return null;
        }
        if (elname.equals("sequence") || elname.equals("choice")) {
            XmlGroupContentModel.Factory group = elname.equals("sequence") ? new XmlSequenceGroup.Factory() : new XmlChoiceGroup.Factory();
            String minOccursStr = el.getAttribute("minOccurs");
            String maxOccursStr = el.getAttribute("maxOccurs");
            if (minOccursStr.length() > 0) {
                try {
                    group.setMinOccur(Integer.parseInt(minOccursStr));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (maxOccursStr.equalsIgnoreCase("unbounded")) {
                group.setMaxOccur(-1);
            } else if (maxOccursStr.length() > 0) {
                try {
                    group.setMaxOccur(Integer.parseInt(maxOccursStr));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            for (Element x : XmlDocumentSchemaParser.elements(el)) {
                XmlContentModel.Factory cm = XmlDocumentSchemaParser.parseContentModel(schema, prefixToNamespaceMap, x);
                if (cm == null) continue;
                group.addNestedContent(cm);
            }
            return group;
        }
        if (elname.equals("extension")) {
            XmlSequenceGroup.Factory sequence = new XmlSequenceGroup.Factory();
            String base = el.getAttribute("base");
            if (base != null) {
                XmlContentModelReference.Factory ref = new XmlContentModelReference.Factory();
                ref.setContentModelName(XmlDocumentSchemaParser.parseQName(base, prefixToNamespaceMap));
                sequence.addNestedContent(ref);
            }
            for (Element x : XmlDocumentSchemaParser.elements(el)) {
                XmlContentModel.Factory cm = XmlDocumentSchemaParser.parseContentModel(schema, prefixToNamespaceMap, x);
                if (cm == null) continue;
                sequence.addNestedContent(cm);
            }
            return sequence;
        }
        if (elname.equals("element")) {
            return XmlDocumentSchemaParser.parseElement(schema, prefixToNamespaceMap, el);
        }
        if (elname.equals("group")) {
            if (el.getAttribute("name").length() > 0) {
                for (Element x : XmlDocumentSchemaParser.elements(el)) {
                    String xname = x.getLocalName();
                    if (!xname.equals("sequence") && !xname.equals("choice")) continue;
                    return XmlDocumentSchemaParser.parseContentModel(schema, prefixToNamespaceMap, x);
                }
                return null;
            }
            XmlContentModelReference.Factory ref = new XmlContentModelReference.Factory();
            String refstr = el.getAttribute("ref");
            ref.setContentModelName(XmlDocumentSchemaParser.parseQName(refstr, prefixToNamespaceMap));
            String minOccursStr = el.getAttribute("minOccurs");
            String maxOccursStr = el.getAttribute("maxOccurs");
            if (minOccursStr.length() > 0) {
                try {
                    ref.setMinOccur(Integer.parseInt(minOccursStr));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (maxOccursStr.equalsIgnoreCase("unbounded")) {
                ref.setMaxOccur(-1);
            } else if (maxOccursStr.length() > 0) {
                try {
                    ref.setMaxOccur(Integer.parseInt(maxOccursStr));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return ref;
        }
        return null;
    }

    private static QName getQName(String name, Map<String, String> prefixToNamespaceMap) {
        String refLocalName;
        String refNamespacePrefix;
        int colon = name.indexOf(58);
        if (colon == -1) {
            refNamespacePrefix = "";
            refLocalName = name;
        } else {
            refNamespacePrefix = name.substring(0, colon);
            refLocalName = name.substring(colon + 1);
        }
        String refNamespace = prefixToNamespaceMap.get(refNamespacePrefix);
        return new QName(refNamespace, refLocalName);
    }

    private static XmlElementDefinition.Factory parseElement(XmlDocumentSchema.Factory schema, Map<String, String> prefixToNamespaceMap, Element el) {
        String substitutionGroup;
        XmlElementDefinition.Factory def;
        QName qname = null;
        QName contentTypeName = null;
        boolean isReference = false;
        String ref = el.getAttribute("ref");
        if (ref.length() > 0) {
            qname = XmlDocumentSchemaParser.getQName(ref, prefixToNamespaceMap);
            isReference = true;
        }
        if (qname == null) {
            String name = el.getAttribute("name");
            qname = new QName(schema.getNamespace(), name);
            Element complexTypeElement = XmlDocumentSchemaParser.element(el, "complexType");
            if (complexTypeElement != null) {
                contentTypeName = schema.createContentModelName();
                XmlContentModel.Factory contentModel = XmlDocumentSchemaParser.parseContentModel(schema, prefixToNamespaceMap, complexTypeElement);
                if (contentModel == null) {
                    schema.removeContentModel(contentTypeName.getLocalPart());
                    contentTypeName = null;
                } else if (contentModel instanceof XmlGroupContentModel.Factory && !((XmlGroupContentModel.Factory)contentModel).hasNestedContent()) {
                    schema.removeContentModel(contentTypeName.getLocalPart());
                    contentTypeName = null;
                } else {
                    schema.addContentModel(contentTypeName.getLocalPart(), contentModel);
                }
            } else {
                String typeAttribute = el.getAttribute("type");
                if (typeAttribute != null) {
                    contentTypeName = XmlDocumentSchemaParser.parseQName(typeAttribute, prefixToNamespaceMap);
                }
            }
        }
        if (isReference) {
            def = new XmlElementDefinitionByReference.Factory();
        } else {
            def = new XmlElementDefinition.Factory();
            def.setContentModelName(contentTypeName);
        }
        def.setName(qname);
        String minOccursStr = el.getAttribute("minOccurs");
        String maxOccursStr = el.getAttribute("maxOccurs");
        if (minOccursStr.length() > 0) {
            try {
                def.setMinOccur(Integer.parseInt(minOccursStr));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (maxOccursStr.equalsIgnoreCase("unbounded")) {
            def.setMaxOccur(-1);
        } else if (maxOccursStr.length() > 0) {
            try {
                def.setMaxOccur(Integer.parseInt(maxOccursStr));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String isAbstract = el.getAttribute("abstract");
        if ("true".equals(isAbstract)) {
            def.setAbstract(true);
        }
        if ((substitutionGroup = el.getAttribute("substitutionGroup")) != null && substitutionGroup.length() > 0) {
            def.setSubstitutionGroup(XmlDocumentSchemaParser.getQName(substitutionGroup, prefixToNamespaceMap));
        }
        return def;
    }

    private static QName parseQName(String qname, Map<String, String> prefixToNamespaceMap) {
        String refLocalName;
        String refNamespacePrefix;
        int colon = qname.indexOf(58);
        if (colon == -1) {
            refNamespacePrefix = "";
            refLocalName = qname;
        } else {
            refNamespacePrefix = qname.substring(0, colon);
            refLocalName = qname.substring(colon + 1);
        }
        String refNamespace = prefixToNamespaceMap.get(refNamespacePrefix);
        return new QName(refNamespace, refLocalName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Element parseSchemaToDom(URL url) {
        DocumentBuilder docbuilder;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(false);
            docbuilder = factory.newDocumentBuilder();
            docbuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            InputStream in;
            block13: {
                Element element;
                in = null;
                try {
                    in = url.openStream();
                    Document doc = docbuilder.parse(in);
                    if (doc == null) break block13;
                    element = doc.getDocumentElement();
                    if (in == null) return element;
                }
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                    return element;
                }
                catch (IOException iOException) {}
                return element;
            }
            if (in == null) return null;
            try {
                in.close();
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception e) {
            String message = parseFailed.format(new Object[]{url.toString()});
            ((LoggingService)Sapphire.service(LoggingService.class)).logError(message, (Throwable)e);
        }
        return null;
    }

    private static Element element(Element el, String name) {
        NodeList nodes = el.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && XmlDocumentSchemaParser.basename(node.getNodeName()).equals(name)) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    private static Iterable<Element> elements(Element el) {
        return new ElementsIterator(el.getChildNodes());
    }

    private static String basename(String name) {
        int colon = name.indexOf(58);
        if (colon != -1) {
            return name.substring(colon + 1);
        }
        return name;
    }

    private static XmlContentModel.Factory inlineContentModelReference(XmlDocumentSchema.Factory schema, XmlContentModel.Factory contentModel, String contentModelName) {
        if (contentModel instanceof XmlContentModelReference.Factory) {
            XmlContentModelReference.Factory ref = (XmlContentModelReference.Factory)contentModel;
            QName name = ref.getContentModelName();
            if (name.getNamespaceURI().equals(schema.getNamespace()) && name.getLocalPart().equals(contentModelName)) {
                return schema.getContentModel(contentModelName);
            }
        } else if (contentModel instanceof XmlGroupContentModel.Factory) {
            XmlGroupContentModel.Factory groupContentModel = (XmlGroupContentModel.Factory)contentModel;
            XmlGroupContentModel.Factory newContentModel = groupContentModel instanceof XmlSequenceGroup.Factory ? new XmlSequenceGroup.Factory() : new XmlChoiceGroup.Factory();
            newContentModel.setMinOccur(contentModel.getMinOccur());
            newContentModel.setMaxOccur(contentModel.getMaxOccur());
            boolean changed = false;
            for (XmlContentModel.Factory in : ((XmlGroupContentModel.Factory)contentModel).getNestedContent()) {
                XmlContentModel.Factory out = XmlDocumentSchemaParser.inlineContentModelReference(schema, in, contentModelName);
                newContentModel.addNestedContent(out);
                if (in == out) continue;
                changed = true;
            }
            if (changed) {
                return newContentModel;
            }
        }
        return contentModel;
    }

    private static final class ElementsIterator
    implements Iterator<Element>,
    Iterable<Element> {
        private final NodeList nodes;
        private final int length;
        private final String name;
        private int position;
        private Element element;

        public ElementsIterator(NodeList nodes) {
            this(nodes, null);
        }

        public ElementsIterator(NodeList nodes, String name) {
            this.nodes = nodes;
            this.length = nodes.getLength();
            this.position = -1;
            this.name = name;
            this.advance();
        }

        private void advance() {
            this.element = null;
            ++this.position;
            while (this.position < this.length && this.element == null) {
                Node node = this.nodes.item(this.position);
                if (node.getNodeType() == 1 && (this.name == null || XmlDocumentSchemaParser.basename(node.getNodeName()).equals(this.name))) {
                    this.element = (Element)node;
                }
                ++this.position;
            }
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        @Override
        public Element next() {
            Element el = this.element;
            if (el == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return el;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Element> iterator() {
            return this;
        }
    }

    public static abstract class Resolver {
        public abstract URL resolve(String var1);
    }
}

