/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jpt.common.utility.internal.model.value.ElementPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.JpaContextModelRoot;
import org.eclipse.jpt.jpa.ui.JpaContextModelRootModel;
import org.eclipse.jpt.jpa.ui.JpaProjectModel;
import org.eclipse.jpt.jpa.ui.JpaProjectsModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{JpaProjectModel.class, JpaContextModelRootModel.class};

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IProject) {
            return this.getAdapter((IProject)adaptableObject, adapterType);
        }
        return null;
    }

    private Object getAdapter(IProject project, Class<?> adapterType) {
        if (adapterType == JpaProjectModel.class) {
            return this.getJpaProjectModel(project);
        }
        if (adapterType == JpaContextModelRootModel.class) {
            return this.getJpaContextModelRootModel(project);
        }
        return null;
    }

    private JpaProjectModel getJpaProjectModel(IProject project) {
        return new JpaProjectModelAdapter(this.getJpaProjectsModel(project.getWorkspace()), project);
    }

    private JpaProjectsModel getJpaProjectsModel(IWorkspace workspace) {
        return (JpaProjectsModel)workspace.getAdapter(JpaProjectsModel.class);
    }

    private JpaContextModelRootModel getJpaContextModelRootModel(IProject project) {
        return new JpaContextModelRootModelAdapter(this.getJpaProjectModel(project));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaContextModelRootModelAdapter
    extends TransformationPropertyValueModel<JpaProject, JpaContextModelRoot>
    implements JpaContextModelRootModel {
        JpaContextModelRootModelAdapter(JpaProjectModel jpaProjectsModel) {
            super((PropertyValueModel)jpaProjectsModel, TransformerTools.nullCheck((Transformer)JpaProject.CONTEXT_MODEL_ROOT_TRANSFORMER));
        }

        @Override
        public IProject getProject() {
            return ((JpaProjectModel)this.valueModel).getProject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaProjectModelAdapter
    extends ElementPropertyValueModelAdapter<JpaProject>
    implements JpaProjectModel {
        JpaProjectModelAdapter(CollectionValueModel<JpaProject> jpaProjectsModel, IProject project) {
            super(jpaProjectsModel, (Predicate)new JpaProject.ProjectEquals(project));
        }

        @Override
        public IProject getProject() {
            return (IProject)((JpaProject.ProjectEquals)this.predicate).getCriterion();
        }
    }
}

