/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;

public class ConvertJavaProjectToJpaCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project = null;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)currentSelection).getFirstElement();
            project = (IProject)PlatformTools.getAdapter((Object)element, IProject.class);
        }
        if (project == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (activeWorkbenchWindow != null) {
            Shell shell = activeWorkbenchWindow.getShell();
            ConvertJavaProjectToJpaRunnable.runInProgressDialog(shell, project);
        }
        return null;
    }

    private static class ConvertJavaProjectToJpaRunnable
    implements IRunnableWithProgress {
        private final IProject project;
        private IFacetedProjectWorkingCopy fprojwc;

        public static void runInProgressDialog(Shell shell, IProject project) {
            boolean startedWithFacetNature = ConvertJavaProjectToJpaRunnable.hasFacetNature(project);
            ConvertJavaProjectToJpaRunnable runnable = new ConvertJavaProjectToJpaRunnable(project);
            try {
                try {
                    new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)runnable);
                }
                catch (InvocationTargetException ex) {
                    JptJpaUiPlugin.instance().logError(ex);
                    return;
                }
                ModifyFacetedProjectWizard wizard = new ModifyFacetedProjectWizard(runnable.getFacetedProjectWorkingCopy());
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                if (dialog.open() == 1) {
                    throw new InterruptedException();
                }
            }
            catch (InterruptedException interruptedException) {
                if (!startedWithFacetNature && ConvertJavaProjectToJpaRunnable.hasFacetNature(project)) {
                    ConvertJavaProjectToJpaRunnable.removeFacetNature(project);
                }
                Thread.currentThread().interrupt();
            }
        }

        protected static boolean hasFacetNature(IProject project) {
            try {
                return project.getDescription().hasNature("org.eclipse.wst.common.project.facet.core.nature");
            }
            catch (CoreException ce) {
                JptJpaUiPlugin.instance().logError(ce);
                return false;
            }
        }

        protected static void removeFacetNature(IProject project) {
            try {
                IProjectDescription description = project.getDescription();
                Object[] prevNatures = description.getNatureIds();
                String[] newNatures = (String[])ArrayTools.remove((Object[])prevNatures, (Object)"org.eclipse.wst.common.project.facet.core.nature");
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
            }
            catch (CoreException ce) {
                JptJpaUiPlugin.instance().logError(ce);
            }
        }

        public ConvertJavaProjectToJpaRunnable(IProject project) {
            this.project = project;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(JptJpaUiMessages.convertToJpa_convertingProject, 1000);
            try {
                try {
                    SubProgressMonitor createProgressMonitor = new SubProgressMonitor(monitor, 100);
                    IFacetedProject fproj = ProjectFacetsManager.create((IProject)this.project, (boolean)true, (IProgressMonitor)createProgressMonitor);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    monitor.setTaskName(JptJpaUiMessages.convertToJpa_detectingTechnologies);
                    SubProgressMonitor detectProgressMonitor = new SubProgressMonitor(monitor, 400);
                    this.fprojwc = fproj.createWorkingCopy();
                    this.fprojwc.detect((IProgressMonitor)detectProgressMonitor);
                    monitor.setTaskName(JptJpaUiMessages.convertToJpa_installingJpaFacet);
                    this.fprojwc.addProjectFacet(JpaProject.FACET.getDefaultVersion());
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }

        protected IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
            return this.fprojwc;
        }
    }
}

