/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.navigator;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.ui.JptCommonUiImages;
import org.eclipse.jpt.common.ui.internal.jface.AbstractItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.JpaContextModelRoot;
import org.eclipse.jpt.jpa.ui.JpaContextModelRootModel;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaContextModelRootModelItemLabelProvider
extends AbstractItemExtendedLabelProvider<JpaContextModelRootModel> {
    protected static final Transformer<JpaContextModelRoot, ImageDescriptor> IMAGE_DESCRIPTOR_TRANSFORMER = new ImageDescriptorTransformer();
    protected static final Transformer<JpaContextModelRoot, String> TEXT_TRANSFORMER = new TextTransformer();
    protected static final Transformer<JpaContextModelRoot, String> DESCRIPTION_TRANSFORMER = new DescriptionTransformer();

    public JpaContextModelRootModelItemLabelProvider(JpaContextModelRootModel rootContextNodeModel, ItemExtendedLabelProvider.Manager manager) {
        super((Object)rootContextNodeModel, manager);
    }

    protected PropertyValueModel<ImageDescriptor> buildImageDescriptorModel() {
        return new TransformationPropertyValueModel((PropertyValueModel)this.item, IMAGE_DESCRIPTOR_TRANSFORMER);
    }

    protected PropertyValueModel<String> buildTextModel() {
        return new TransformationPropertyValueModel((PropertyValueModel)this.item, TEXT_TRANSFORMER);
    }

    protected PropertyValueModel<String> buildDescriptionModel() {
        return new TransformationPropertyValueModel((PropertyValueModel)this.item, DESCRIPTION_TRANSFORMER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DescriptionTransformer
    extends AbstractTransformer<JpaContextModelRoot, String> {
        protected DescriptionTransformer() {
        }

        public String transform_(JpaContextModelRoot root) {
            StringBuilder sb = new StringBuilder();
            sb.append(JptJpaUiMessages.JpaContent_label);
            sb.append(" - ");
            sb.append(root.getResource().getFullPath().makeRelative());
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ImageDescriptorTransformer
    extends TransformerAdapter<JpaContextModelRoot, ImageDescriptor> {
        protected ImageDescriptorTransformer() {
        }

        public ImageDescriptor transform(JpaContextModelRoot root) {
            return JptCommonUiImages.gray((ImageDescriptor)JptJpaUiImages.JPA_CONTENT, (root == null ? 1 : 0) != 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TextTransformer
    extends TransformerAdapter<JpaContextModelRoot, String> {
        protected TextTransformer() {
        }

        public String transform(JpaContextModelRoot root) {
            String text = JptJpaUiMessages.JpaContent_label;
            return root != null ? text : "[" + text + "]";
        }
    }
}

