/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.navigator;

import java.util.HashMap;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeStateProviderFactoryProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.ui.JpaContextModelRootModel;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.internal.navigator.JpaContextModelRootModelItemLabelProvider;

public class JpaNavigatorItemLabelProviderFactory
implements ItemExtendedLabelProvider.Factory {
    private final HashMap<JpaPlatform, ItemExtendedLabelProvider.Factory> delegates = new HashMap();

    public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
        if (item instanceof JpaContextModelRootModel) {
            return this.buildContextModelRootModelProvider((JpaContextModelRootModel)item, manager);
        }
        ItemExtendedLabelProvider.Factory delegate = this.getDelegate(item);
        return delegate == null ? null : delegate.buildProvider(item, manager);
    }

    protected ItemExtendedLabelProvider buildContextModelRootModelProvider(JpaContextModelRootModel item, ItemExtendedLabelProvider.Manager manager) {
        return new JpaContextModelRootModelItemLabelProvider(item, manager);
    }

    private ItemExtendedLabelProvider.Factory getDelegate(Object item) {
        return item instanceof JpaContextModel ? this.getDelegate((JpaContextModel)item) : null;
    }

    private synchronized ItemExtendedLabelProvider.Factory getDelegate(JpaContextModel item) {
        JpaPlatform jpaPlatform = item.getJpaProject().getJpaPlatform();
        ItemExtendedLabelProvider.Factory delegate = this.delegates.get(jpaPlatform);
        if (delegate == null && !this.delegates.containsKey(jpaPlatform)) {
            delegate = this.buildDelegate(jpaPlatform);
            this.delegates.put(jpaPlatform, delegate);
        }
        return delegate;
    }

    private ItemExtendedLabelProvider.Factory buildDelegate(JpaPlatform jpaPlatform) {
        JpaPlatformUi platformUI = (JpaPlatformUi)jpaPlatform.getAdapter(JpaPlatformUi.class);
        if (platformUI == null) {
            return null;
        }
        ItemTreeStateProviderFactoryProvider factoryProvider = platformUI.getNavigatorFactoryProvider();
        return factoryProvider == null ? null : factoryProvider.getItemLabelProviderFactory();
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }
}

