/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.internal.builder.ChangedFileOutputStream;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractEclipseBuildContext
implements BuildContext {
    private final Set<File> refresh = new HashSet<File>();
    protected final Map<String, Object> context;
    private String currentBuildParticipantId;
    private final Map<String, List<Message>> messages = new LinkedHashMap<String, List<Message>>();
    private final Map<String, List<File>> removeMessages = new LinkedHashMap<String, List<File>>();

    protected AbstractEclipseBuildContext(Map<String, Object> context) {
        this.context = context;
    }

    public void refresh(File file) {
        this.refresh.add(file);
    }

    public Set<File> getFiles() {
        return this.refresh;
    }

    public OutputStream newFileOutputStream(File file) throws IOException {
        return new ChangedFileOutputStream(file, this);
    }

    protected IPath getRelativePath(File file) {
        IPath path;
        IPath basepath = this.getBaseResource().getLocation();
        if (!basepath.isPrefixOf(path = Path.fromOSString((String)file.getAbsolutePath()))) {
            return null;
        }
        return path.removeFirstSegments(basepath.segmentCount());
    }

    protected IResource getResource(File file) {
        IPath relpath = this.getRelativePath(file);
        if (relpath == null) {
            return null;
        }
        IResource baseResource = this.getBaseResource();
        if (baseResource instanceof IContainer) {
            return ((IContainer)baseResource).findMember(relpath);
        }
        return null;
    }

    protected abstract IResource getBaseResource();

    public void setValue(String key, Object value) {
        this.context.put(key, value);
    }

    public Object getValue(String key) {
        return this.context.get(key);
    }

    public void addError(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 2, cause);
    }

    public void addWarning(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 1, cause);
    }

    public void addMessage(File file, int line, int column, String message, int severity, Throwable cause) {
        if (this.currentBuildParticipantId == null) {
            throw new IllegalStateException("currentBuildParticipantId cannot be null or empty");
        }
        List<Message> messageList = this.messages.get(this.currentBuildParticipantId);
        if (messageList == null) {
            messageList = new ArrayList<Message>();
            this.messages.put(this.currentBuildParticipantId, messageList);
        }
        messageList.add(new Message(file, line, column, message, severity, cause));
    }

    public void removeMessages(File file) {
        if (this.currentBuildParticipantId == null) {
            throw new IllegalStateException("currentBuildParticipantId cannot be null or empty");
        }
        List<File> files = this.removeMessages.get(this.currentBuildParticipantId);
        if (files == null) {
            files = new ArrayList<File>();
            this.removeMessages.put(this.currentBuildParticipantId, files);
        }
        files.add(file);
    }

    public Map<String, List<Message>> getMessages() {
        return this.messages;
    }

    public Map<String, List<File>> getRemoveMessages() {
        return this.removeMessages;
    }

    public boolean isUptodate(File target, File source) {
        IResource targetResource = this.getResource(target);
        IResource sourceResource = this.getResource(source);
        return targetResource != null && targetResource.isAccessible() && !this.hasDelta(target) && sourceResource != null && sourceResource.isAccessible() && !this.hasDelta(source) && targetResource.getLocalTimeStamp() >= sourceResource.getLocalTimeStamp();
    }

    public void setCurrentBuildParticipantId(String currentBuildParticipantId) {
        this.currentBuildParticipantId = currentBuildParticipantId;
    }

    public static class Message {
        public final File file;
        public final int line;
        public final int column;
        public final String message;
        public final int severity;
        public final Throwable cause;

        Message(File file, int line, int column, String message, int severity, Throwable cause) {
            this.file = file;
            this.line = line;
            this.column = column;
            if (message == null && cause != null) {
                message = cause.getMessage();
            }
            this.message = message;
            this.severity = severity;
            this.cause = cause;
        }
    }
}

