/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.form;

import com.liferay.ide.ui.form.IFormEntryListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FormEntry {
    private Control fLabel;
    private Text fText;
    private Button fBrowse;
    private String fValue = "";
    private boolean fDirty;
    boolean fIgnoreModify = false;
    private IFormEntryListener fListener;
    public static final int F_DEFAULT_TEXT_WIDTH_HINT = 100;

    public FormEntry(Composite parent, FormToolkit toolkit, String labelText, int style) {
        this.createControl(parent, toolkit, labelText, style, null, false, 0, 0);
    }

    public FormEntry(Composite parent, FormToolkit toolkit, String labelText, String browseText, boolean linkLabel) {
        this(parent, toolkit, labelText, browseText, linkLabel, 0);
    }

    public FormEntry(Composite parent, FormToolkit toolkit, String labelText, String browseText, boolean linkLabel, int indent) {
        this.createControl(parent, toolkit, labelText, 4, browseText, linkLabel, indent, 0);
    }

    public FormEntry(Composite parent, FormToolkit toolkit, String labelText, int indent, int tcolspan) {
        this.createControl(parent, toolkit, labelText, 4, null, false, indent, tcolspan);
    }

    private void createControl(Composite parent, FormToolkit toolkit, String labelText, int style, String browseText, boolean linkLabel, int indent, int tcolspan) {
        if (linkLabel) {
            Hyperlink link = toolkit.createHyperlink(parent, labelText, 0);
            this.fLabel = link;
        } else if (labelText != null) {
            this.fLabel = toolkit.createLabel(parent, labelText);
            this.fLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        }
        this.fText = toolkit.createText(parent, "", style);
        this.addListeners();
        if (browseText != null) {
            this.fBrowse = toolkit.createButton(parent, browseText, 8);
            this.fBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FormEntry.this.fListener != null) {
                        FormEntry.this.fListener.browseButtonSelected(FormEntry.this);
                    }
                }
            });
        }
        this.fillIntoGrid(parent, indent, tcolspan);
        this.setTextWidthHint(100);
    }

    public void setEditable(boolean editable) {
        this.fText.setEditable(editable);
        if (this.fLabel instanceof Hyperlink) {
            ((Hyperlink)this.fLabel).setUnderlined(editable);
        }
        if (this.fBrowse != null) {
            this.fBrowse.setEnabled(editable);
        }
    }

    private void fillIntoGrid(Composite parent, int indent, int tcolspan) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            GridData gd;
            int tspan;
            int span = ((GridLayout)layout).numColumns;
            if (tcolspan > 0) {
                tspan = tcolspan;
            } else {
                int n = tspan = this.fBrowse != null ? span - 2 : span - 1;
            }
            if (this.fLabel != null) {
                gd = new GridData(4);
                gd.horizontalIndent = indent;
                this.fLabel.setLayoutData((Object)gd);
            }
            gd = new GridData(256);
            gd.horizontalSpan = tspan;
            if (this.fLabel != null) {
                gd.horizontalIndent = 3;
            }
            gd.grabExcessHorizontalSpace = tspan == 1;
            gd.widthHint = 10;
            this.fText.setLayoutData((Object)gd);
            if (this.fBrowse != null) {
                gd = new GridData(4);
                this.fBrowse.setLayoutData((Object)gd);
            }
        } else if (layout instanceof TableWrapLayout) {
            TableWrapData td;
            int tspan;
            int span = ((TableWrapLayout)layout).numColumns;
            if (tcolspan > 0) {
                tspan = tcolspan;
            } else {
                int n = tspan = this.fBrowse != null ? span - 2 : span - 1;
            }
            if (this.fLabel != null) {
                td = new TableWrapData();
                td.valign = 32;
                td.indent = indent;
                this.fLabel.setLayoutData((Object)td);
            }
            td = new TableWrapData(128);
            td.colspan = tspan;
            if (this.fLabel != null) {
                td.indent = 3;
            }
            td.grabHorizontal = tspan == 1;
            td.valign = 32;
            this.fText.setLayoutData((Object)td);
            if (this.fBrowse != null) {
                td = new TableWrapData(128);
                td.valign = 32;
                this.fBrowse.setLayoutData((Object)td);
            }
        }
    }

    public void setFormEntryListener(IFormEntryListener listener) {
        if (this.fLabel != null && this.fLabel instanceof Hyperlink) {
            if (this.fListener != null) {
                ((Hyperlink)this.fLabel).removeHyperlinkListener((IHyperlinkListener)this.fListener);
            }
            if (listener != null) {
                ((Hyperlink)this.fLabel).addHyperlinkListener((IHyperlinkListener)listener);
            }
        }
        this.fListener = listener;
    }

    private void addListeners() {
        this.fText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FormEntry.this.keyReleaseOccured(e);
            }
        });
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormEntry.this.editOccured(e);
            }
        });
        this.fText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (FormEntry.this.fListener != null) {
                    FormEntry.this.fListener.focusGained(FormEntry.this);
                }
            }

            public void focusLost(FocusEvent e) {
                if (FormEntry.this.fDirty) {
                    FormEntry.this.commit();
                }
            }
        });
    }

    public void commit() {
        if (this.fDirty) {
            this.fValue = this.fText.getText();
            if (this.fListener != null) {
                this.fListener.textValueChanged(this);
            }
        }
        this.fDirty = false;
    }

    public void cancelEdit() {
        this.fDirty = false;
    }

    private void editOccured(ModifyEvent e) {
        if (this.fIgnoreModify) {
            return;
        }
        this.fDirty = true;
        if (this.fListener != null) {
            this.fListener.textDirty(this);
        }
    }

    public Text getText() {
        return this.fText;
    }

    public Control getLabel() {
        return this.fLabel;
    }

    public Button getButton() {
        return this.fBrowse;
    }

    public String getValue() {
        return this.fValue.trim();
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    private void keyReleaseOccured(KeyEvent e) {
        if (e.character == '\r') {
            if (this.fDirty) {
                this.commit();
            }
        } else if (e.character == '\u001b') {
            if (!this.fValue.equals(this.fText.getText())) {
                this.fText.setText(this.fValue != null ? this.fValue : "");
            }
            this.fDirty = false;
        }
        if (this.fListener != null) {
            this.fListener.selectionChanged(this);
        }
    }

    public void setValue(String value) {
        if (this.fText != null) {
            this.fText.setText(value != null ? value : "");
        }
        this.fValue = value != null ? value : "";
    }

    public void setValue(String value, boolean blockNotification) {
        this.fIgnoreModify = blockNotification;
        this.setValue(value);
        this.fIgnoreModify = false;
    }

    public void setVisible(boolean visible) {
        if (this.fLabel != null) {
            this.fLabel.setVisible(visible);
        }
        if (this.fText != null) {
            this.fText.setVisible(visible);
        }
        if (this.fBrowse != null) {
            this.fBrowse.setVisible(visible);
        }
    }

    public void setTextWidthHint(int width) {
        Object data = this.getText().getLayoutData();
        if (data == null) {
            return;
        }
        if (data instanceof GridData) {
            ((GridData)data).widthHint = width;
        } else if (data instanceof TableWrapData) {
            ((TableWrapData)data).maxWidth = width;
        }
    }
}

