/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.form;

import com.liferay.ide.core.model.IBaseModel;
import com.liferay.ide.core.model.IWorkspaceModel;
import com.liferay.ide.ui.LiferayUIPlugin;
import com.liferay.ide.ui.editor.IDEFormEditorContributor;
import com.liferay.ide.ui.editor.IInputContextListener;
import com.liferay.ide.ui.editor.IModelUndoManager;
import com.liferay.ide.ui.editor.InputContext;
import com.liferay.ide.ui.editor.InputContextManager;
import com.liferay.ide.ui.form.IDEFormPage;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

public abstract class IDEFormEditor
extends FormEditor
implements IInputContextListener {
    private IDEFormEditorChangeListener fEditorSelectionChangedListener;
    private Clipboard clipboard;
    private Menu fContextMenu;
    protected InputContextManager fInputContextManager = this.createInputContextManager();
    private String fLastActivePageId;
    private boolean fLastDirtyState;
    private boolean fError;

    protected IEditorSite createSite(IEditorPart editor) {
        return new IDEMultiPageEditorSite((MultiPageEditorPart)this, editor);
    }

    public IProject getCommonProject() {
        return this.fInputContextManager.getCommonProject();
    }

    public IBaseModel getModel() {
        if (this.fInputContextManager != null) {
            return this.fInputContextManager.getModel();
        }
        return null;
    }

    protected abstract InputContextManager createInputContextManager();

    public boolean hasInputContext(String contextId) {
        return this.fInputContextManager.hasContext(contextId);
    }

    public InputContextManager getContextManager() {
        return this.fInputContextManager;
    }

    protected void createInputContexts(InputContextManager contextManager) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            this.createResourceContexts(contextManager, (IFileEditorInput)input);
        }
    }

    protected abstract void createResourceContexts(InputContextManager var1, IFileEditorInput var2);

    protected void createPages() {
        this.clipboard = new Clipboard(this.getContainer().getDisplay());
        MenuManager manager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IDEFormEditor.this.contextMenuAboutToShow(manager);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        this.fContextMenu = manager.createContextMenu((Control)this.getContainer());
        this.getContainer().setMenu(this.fContextMenu);
        this.createInputContexts(this.fInputContextManager);
        super.createPages();
        this.fInputContextManager.addInputContextListener(this);
        this.updateTitle();
        if (this.getPageCount() == 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            this.fLastActivePageId = page.getId();
        }
    }

    public void setFocus() {
        super.setFocus();
        IFormPage page = this.getActivePageInstance();
        if (page != null && page instanceof IDEFormPage) {
            ((IDEFormPage)page).updateFormSelection();
        }
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        IDEFormEditorContributor contributor = this.getContributor();
        IFormPage page = this.getActivePageInstance();
        if (page instanceof IDEFormPage) {
            ((IDEFormPage)page).contextMenuAboutToShow(manager);
        }
        if (contributor != null) {
            contributor.contextMenuAboutToShow(manager);
        }
    }

    public IDEFormEditorContributor getContributor() {
        return (IDEFormEditorContributor)this.getEditorSite().getActionBarContributor();
    }

    private String getFirstInvalidContextId() {
        InputContext[] invalidContexts = this.fInputContextManager.getInvalidContexts();
        if (invalidContexts.length == 0) {
            return null;
        }
        int i = 0;
        while (i < invalidContexts.length) {
            if (invalidContexts[i].isPrimary()) {
                return invalidContexts[i].getId();
            }
            ++i;
        }
        return invalidContexts[0].getId();
    }

    public String getTitle() {
        if (this.fInputContextManager == null) {
            return super.getTitle();
        }
        InputContext context = this.fInputContextManager.getPrimaryContext();
        if (context == null) {
            return super.getTitle();
        }
        return context.getInput().getName();
    }

    public void updateTitle() {
        this.firePropertyChange(1);
    }

    public String getTitleProperty() {
        return "";
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitPages(true);
        this.fInputContextManager.save(monitor);
        this.editorDirtyStateChanged();
    }

    public void doRevert() {
        boolean reverted;
        IFormPage formPage = this.getActivePageInstance();
        if (formPage != null && formPage instanceof IDEFormPage) {
            formPage.getManagedForm().commit(true);
        }
        if (!(reverted = this.doRevertSourcePages())) {
            reverted = this.doRevertFormPage();
        }
        if (reverted) {
            this.editorDirtyStateChanged();
        }
    }

    private boolean doRevertFormPage() {
        boolean reverted = false;
        IBaseModel model = this.getModel();
        if (model instanceof IWorkspaceModel) {
            IWorkspaceModel workspaceModel = (IWorkspaceModel)model;
            workspaceModel.reload();
            reverted = true;
        }
        return reverted;
    }

    private boolean doRevertSourcePages() {
        boolean reverted = false;
        return reverted;
    }

    public void doRevert(IEditorInput input) {
        this.editorDirtyStateChanged();
    }

    public String getContextIDForSaveAs() {
        return null;
    }

    public void doSaveAs() {
        try {
            String contextID = this.getContextIDForSaveAs();
            this.getContextManager().saveAs(this.getProgressMonitor(), contextID);
            IEditorInput input = this.getContextManager().findContext(contextID).getInput();
            this.setInputWithNotify(input);
            this.setPartName(input.getName());
            this.firePropertyChange(257);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            String message = "Save not completed.";
            if (e.getMessage() != null) {
                message = String.valueOf(message) + ' ' + e.getMessage();
            }
            LiferayUIPlugin.logError(e);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void storeDefaultPage() {
        IEditorInput input = this.getEditorInput();
        String pageId = this.fLastActivePageId;
        if (pageId == null) {
            return;
        }
        if (!(input instanceof IFileEditorInput)) {
            boolean cfr_ignored_0 = input instanceof IStorageEditorInput;
        }
    }

    protected abstract String getEditorID();

    public void dispose() {
        this.storeDefaultPage();
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSite().getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
        this.fInputContextManager.dispose();
        this.fInputContextManager = null;
    }

    public boolean isDirty() {
        this.fLastDirtyState = this.computeDirtyState();
        return this.fLastDirtyState;
    }

    private boolean computeDirtyState() {
        IFormPage page = this.getActivePageInstance();
        if (page != null && page.isDirty() || this.fInputContextManager != null && this.fInputContextManager.isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    public boolean getLastDirtyState() {
        return this.fLastDirtyState;
    }

    public void fireSaveNeeded(String contextId, boolean notify) {
        if (contextId == null) {
            return;
        }
        InputContext context = this.fInputContextManager.findContext(contextId);
        if (context != null) {
            this.fireSaveNeeded(context.getInput(), notify);
        }
    }

    public void fireSaveNeeded(IEditorInput input, boolean notify) {
        if (notify) {
            this.editorDirtyStateChanged();
        }
        if (this.isDirty()) {
            this.validateEdit(input);
        }
    }

    public void editorDirtyStateChanged() {
        super.editorDirtyStateChanged();
        IDEFormEditorContributor contributor = this.getContributor();
        if (contributor != null) {
            contributor.updateActions();
        }
    }

    private void validateEdit(IEditorInput input) {
        final InputContext context = this.fInputContextManager.getContext(input);
        if (!context.validateEdit()) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IDEFormEditor.this.doRevert(context.getInput());
                    context.setValidated(false);
                }
            });
        }
    }

    public void gotoMarker(IMarker marker) {
        IResource resource = marker.getResource();
        InputContext context = this.fInputContextManager.findContext(resource);
        if (context == null) {
            return;
        }
        IFormPage page = this.getActivePageInstance();
        if (!context.getId().equals(page.getId())) {
            page = this.setActivePage(context.getId());
        }
        IDE.gotoMarker((IEditorPart)page, (IMarker)marker);
    }

    public void openToSourcePage(Object object, int offset, int length) {
        if (object instanceof InputContext) {
            InputContext cfr_ignored_0 = (InputContext)object;
        } else {
            this.getInputContext(object);
        }
    }

    public void setSelection(ISelection selection) {
        this.getSite().getSelectionProvider().setSelection(selection);
        this.getContributor().updateSelectableActions(selection);
    }

    public ISelection getSelection() {
        return this.getSite().getSelectionProvider().getSelection();
    }

    public Object getAdapter(Class key) {
        return super.getAdapter(key);
    }

    public Menu getContextMenu() {
        return this.fContextMenu;
    }

    IFormPage[] getPages() {
        ArrayList formPages = new ArrayList();
        int i = 0;
        while (i < this.pages.size()) {
            Object page = this.pages.get(i);
            if (page instanceof IFormPage) {
                formPages.add(page);
            }
            ++i;
        }
        return formPages.toArray(new IFormPage[formPages.size()]);
    }

    public void performGlobalAction(String id) {
        IFormPage page;
        ISelection selection = this.getSelection();
        boolean handled = ((IDEFormPage)this.getActivePageInstance()).performGlobalAction(id);
        if (!handled && (page = this.getActivePageInstance()) instanceof IDEFormPage) {
            if (id.equals(ActionFactory.UNDO.getId())) {
                this.fInputContextManager.undo();
                return;
            }
            if (id.equals(ActionFactory.REDO.getId())) {
                this.fInputContextManager.redo();
                return;
            }
            if (id.equals(ActionFactory.CUT.getId()) || id.equals(ActionFactory.COPY.getId())) {
                this.copyToClipboard(selection);
                return;
            }
        }
    }

    private void copyToClipboard(ISelection selection) {
    }

    public boolean canPasteFromClipboard() {
        return false;
    }

    public boolean canCopy(ISelection selection) {
        if (selection == null) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            return !selection.isEmpty();
        }
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            return textSelection.getLength() > 0;
        }
        return false;
    }

    public boolean canCut(ISelection selection) {
        return this.canCopy(selection);
    }

    public void updateUndo(IAction undoAction, IAction redoAction) {
        IModelUndoManager undoManager = this.fInputContextManager.getUndoManager();
        if (undoManager != null) {
            undoManager.setActions(undoAction, redoAction);
        }
    }

    protected abstract InputContext getInputContext(Object var1);

    protected abstract void addPages();

    public final void contextAdded(InputContext context) {
        if (this.fError) {
            this.removePage(0);
            this.addPages();
        } else {
            this.editorContextAdded(context);
        }
    }

    public abstract void editorContextAdded(InputContext var1);

    protected IProgressMonitor getProgressMonitor() {
        IProgressMonitor monitor = null;
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            monitor = manager.getProgressMonitor();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    protected IStatusLineManager getStatusLineManager() {
        return this.getEditorSite().getActionBars().getStatusLineManager();
    }

    public void contributeToToolbar(IToolBarManager manager) {
    }

    public class IDEFormEditorChangeListener
    implements ISelectionChangedListener {
        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private static class IDEMultiPageEditorSite
    extends MultiPageEditorSite {
        public IDEMultiPageEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
            super(multiPageEditor, editor);
        }

        public IEditorActionBarContributor getActionBarContributor() {
            IDEFormEditor editor = (IDEFormEditor)this.getMultiPageEditor();
            IDEFormEditorContributor contributor = editor.getContributor();
            return contributor.getSourceContributor();
        }

        public IWorkbenchPart getPart() {
            return this.getMultiPageEditor();
        }
    }
}

