/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.alloy.core;

import com.liferay.ide.alloy.core.AlloyCore;
import com.liferay.ide.core.jna.LibraryUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.core.util.LaunchHelper;
import com.liferay.ide.core.util.ZipUtil;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.osgi.framework.Bundle;

public class LautRunner {
    private static final String _LAUT_VERSION = "1.0.6";
    private static final String LAUT_ENTRY = "laut-1.0.6";
    private static final String LAUT_PATH = "com.liferay.laut.LautRunnerPath";
    private static final String LAUT_ZIP = "laut-1.0.6.zip";
    private static final String[] lautExeFiles = new String[]{"run.sh", "node/bin/node"};

    static {
        LautRunner.initializeLautRunner();
    }

    private static void initializeLautRunner() {
        File lautRunnerFile;
        String lautRunnerPath = System.getProperty(LAUT_PATH);
        if (lautRunnerPath != null && !(lautRunnerFile = new File(lautRunnerPath)).exists()) {
            lautRunnerPath = null;
        }
        if (lautRunnerPath == null) {
            try {
                Bundle lautRunnerBundle = AlloyCore.getDefault().getBundle();
                URL lautUrl = null;
                if (lautRunnerBundle == null) {
                    AlloyCore.logError("Unable to find laut bundle.");
                } else {
                    Enumeration lautEntries = lautRunnerBundle.findEntries("/laut-1.0.6", "/", false);
                    if (lautEntries == null || !lautEntries.hasMoreElements()) {
                        Enumeration lautZipEntries = lautRunnerBundle.findEntries("/", LAUT_ZIP, false);
                        if (lautZipEntries != null && lautZipEntries.hasMoreElements()) {
                            File lautZipFile = new File(FileLocator.toFileURL((URL)((URL)lautZipEntries.nextElement())).getFile());
                            File lautBundleDir = lautZipFile.getParentFile();
                            File lautDir = new File(lautBundleDir, LAUT_ENTRY);
                            if (!lautBundleDir.canWrite()) {
                                lautDir = AlloyCore.getDefault().getStateLocation().append(LAUT_ENTRY).toFile();
                                FileUtil.deleteDir((File)lautDir, (boolean)true);
                            }
                            ZipUtil.unzip((File)lautZipFile, (File)lautDir.getParentFile());
                            new File(lautBundleDir, "laut").renameTo(lautDir);
                            Enumeration lautPathEntries = lautRunnerBundle.findEntries("/laut-1.0.6", "/", false);
                            lautUrl = (URL)lautPathEntries.nextElement();
                        }
                    } else {
                        lautUrl = (URL)lautEntries.nextElement();
                    }
                    if (lautUrl != null) {
                        File lautRunnerDir = new File(FileLocator.toFileURL((URL)lautUrl).getFile());
                        String lautRunnerDirPath = lautRunnerDir.getAbsolutePath();
                        System.setProperty(LAUT_PATH, lautRunnerDirPath);
                        LautRunner.setSDKExecutableFlags((IPath)new Path(lautRunnerDirPath));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void setSDKExecutableFlags(IPath lautDir) {
        if (LibraryUtil.getLibC() == null) {
            return;
        }
        String[] stringArray = lautExeFiles;
        int n = lautExeFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String exeFile = stringArray[n2];
            LibraryUtil.getLibC().chmod(lautDir.append(exeFile).toOSString(), 493);
            ++n2;
        }
    }

    public void exec(IProject project, IProgressMonitor monitor) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        try {
            String projectName = project.getName();
            ILaunchConfigurationWorkingCopy config = configType.newInstance(null, lm.generateLaunchConfigurationName("laut-1.0.6 " + projectName));
            config.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
            config.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_CONSOLE", true);
            config.setAttribute("org.eclipse.debug.ui.ATTR_PRIVATE", true);
            config.setAttribute("org.eclipse.debug.core.ATTR_REFRESH_SCOPE", "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?><resources><item path=\"/" + project.getName() + "\" type=\"4\"/></resources>}");
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE", "${projects:" + projectName + "}");
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", this.getExecPath());
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "-f \"" + project.getLocation().toOSString() + "\"");
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", this.getWorkingPath().toOSString());
            new LaunchHelper().launch((ILaunchConfiguration)config, "run", monitor);
        }
        catch (CoreException e) {
            AlloyCore.logError("Problem launching laut tool.", (Exception)((Object)e));
        }
    }

    public String getExecPath() {
        return this.getWorkingPath().append(Platform.getOS().contains("win") ? "run.bat" : "run.sh").toOSString();
    }

    private Path getWorkingPath() {
        return new Path(System.getProperty(LAUT_PATH));
    }

    public boolean hasUpdateAvailable() {
        return false;
    }
}

