/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.ui.internal.launch;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.embedder.MavenRuntimeManager;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MavenRuntimeSelector
extends Composite {
    ComboViewer runtimeComboViewer;
    private MavenRuntimeManager runtimeManager;

    public MavenRuntimeSelector(final Composite mainComposite) {
        super(mainComposite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        Label mavenRuntimeLabel = new Label((Composite)this, 0);
        mavenRuntimeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        mavenRuntimeLabel.setText(Messages.MavenLaunchMainTab_lblRuntime);
        this.runtimeComboViewer = new ComboViewer((Composite)this, 2056);
        this.runtimeComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.runtimeComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object input) {
                return ((List)input).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        try {
            this.runtimeManager = MavenPlugin.getMavenRuntimeManager();
            this.runtimeComboViewer.setInput((Object)this.runtimeManager.getMavenRuntimes());
            this.runtimeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.runtimeManager.getDefaultRuntime()));
        }
        catch (NullPointerException nullPointerException) {}
        Button configureRuntimesButton = new Button((Composite)this, 0);
        configureRuntimesButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        configureRuntimesButton.setText(Messages.MavenLaunchMainTab_btnConfigure);
        configureRuntimesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)mainComposite.getShell(), (String)"org.eclipse.m2e.core.preferences.MavenInstallationsPreferencePage", null, null).open();
                MavenRuntimeManager runtimeManager = MavenPlugin.getMavenRuntimeManager();
                MavenRuntimeSelector.this.runtimeComboViewer.setInput((Object)runtimeManager.getMavenRuntimes());
                MavenRuntimeSelector.this.runtimeComboViewer.setSelection((ISelection)new StructuredSelection((Object)runtimeManager.getDefaultRuntime()));
            }
        });
    }

    public void setSelectRuntime(MavenRuntime runtime) {
        this.runtimeComboViewer.setSelection((ISelection)new StructuredSelection((Object)runtime));
    }

    public MavenRuntime getSelectedRuntime() {
        IStructuredSelection selection = (IStructuredSelection)this.runtimeComboViewer.getSelection();
        return (MavenRuntime)selection.getFirstElement();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.runtimeComboViewer.addSelectionChangedListener(listener);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String location = "";
        try {
            location = configuration.getAttribute("M2_RUNTIME", "");
        }
        catch (CoreException coreException) {}
        MavenRuntime runtime = this.runtimeManager.getRuntime(location);
        if (runtime != null) {
            this.setSelectRuntime(runtime);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        MavenRuntime runtime = this.getSelectedRuntime();
        configuration.setAttribute("M2_RUNTIME", runtime.getLocation());
    }
}

