/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.core;

import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.InMemoryCredentialsStore;

public class SecureCredentialsStore
implements ICredentialsStore {
    private static final String ID_NODE = "org.eclipse.mylyn.commons.repository";
    private final String id;
    private InMemoryCredentialsStore inMemoryStore;
    private boolean loggedStorageException;

    public SecureCredentialsStore(String id) {
        this.id = id;
    }

    @Override
    public void clear() {
        this.getSecurePreferences().removeNode();
        this.getInMemoryStore().clear();
    }

    @Override
    public synchronized void copyTo(ICredentialsStore target) {
        Assert.isNotNull((Object)target);
        if (!(target instanceof SecureCredentialsStore)) {
            throw new IllegalArgumentException("SecureCredentialsStore may only by copied to stores of the same type: " + target.getClass());
        }
        ISecurePreferences preferences = this.getSecurePreferences();
        String[] stringArray = preferences.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            try {
                String value = preferences.get(key, null);
                boolean encrypted = preferences.isEncrypted(key);
                target.put(key, value, encrypted);
            }
            catch (StorageException e) {
                this.handle(e);
            }
            ++n2;
        }
        if (this.inMemoryStore != null) {
            this.inMemoryStore.copyTo(target);
        }
    }

    @Override
    public void flush() throws IOException {
        this.getSecurePreferences().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key, String def) {
        InMemoryCredentialsStore memoryStore;
        InMemoryCredentialsStore inMemoryCredentialsStore = memoryStore = this.getInMemoryStore();
        synchronized (inMemoryCredentialsStore) {
            if (memoryStore.hasKey(key)) {
                return memoryStore.get(key, def);
            }
        }
        try {
            return this.getSecurePreferences().get(key, def);
        }
        catch (StorageException e) {
            this.handle(e);
            return memoryStore.get(key, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String key, boolean def) {
        InMemoryCredentialsStore memoryStore;
        InMemoryCredentialsStore inMemoryCredentialsStore = memoryStore = this.getInMemoryStore();
        synchronized (inMemoryCredentialsStore) {
            if (memoryStore.hasKey(key)) {
                return memoryStore.getBoolean(key, def);
            }
        }
        try {
            return this.getSecurePreferences().getBoolean(key, def);
        }
        catch (StorageException e) {
            this.handle(e);
            return memoryStore.getBoolean(key, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getByteArray(String key, byte[] def) {
        InMemoryCredentialsStore memoryStore;
        InMemoryCredentialsStore inMemoryCredentialsStore = memoryStore = this.getInMemoryStore();
        synchronized (inMemoryCredentialsStore) {
            if (memoryStore.hasKey(key)) {
                return memoryStore.getByteArray(key, def);
            }
        }
        try {
            return this.getSecurePreferences().getByteArray(key, def);
        }
        catch (StorageException e) {
            this.handle(e);
            return memoryStore.getByteArray(key, def);
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String[] keys() {
        return this.getSecurePreferences().keys();
    }

    @Override
    public void put(String key, String value, boolean encrypt) {
        this.put(key, value, encrypt, true);
    }

    @Override
    public void put(String key, String value, boolean encrypt, boolean persist) {
        if (persist) {
            try {
                this.getSecurePreferences().put(key, value, encrypt);
                this.getInMemoryStore().remove(key);
            }
            catch (StorageException e) {
                this.handle(e);
                this.getInMemoryStore().put(key, value, encrypt, true);
            }
        } else {
            this.getInMemoryStore().put(key, value, encrypt, false);
            this.getSecurePreferences().remove(key);
        }
    }

    @Override
    public void putBoolean(String key, boolean value, boolean encrypt) {
        try {
            this.getSecurePreferences().putBoolean(key, value, encrypt);
            this.getInMemoryStore().remove(key);
        }
        catch (StorageException e) {
            this.handle(e);
            this.getInMemoryStore().putBoolean(key, value, encrypt);
        }
    }

    @Override
    public void putByteArray(String key, byte[] value, boolean encrypt) {
        try {
            this.getSecurePreferences().putByteArray(key, value, encrypt);
            this.getInMemoryStore().remove(key);
        }
        catch (StorageException e) {
            this.handle(e);
            this.getInMemoryStore().putByteArray(key, value, encrypt);
        }
    }

    @Override
    public void remove(String key) {
        this.getSecurePreferences().remove(key);
    }

    protected synchronized InMemoryCredentialsStore getInMemoryStore() {
        if (this.inMemoryStore == null) {
            this.inMemoryStore = InMemoryCredentialsStore.getStore(this.id);
        }
        return this.inMemoryStore;
    }

    protected ISecurePreferences getSecurePreferences() {
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault().node(ID_NODE);
        securePreferences = securePreferences.node(EncodingUtils.encodeSlashes((String)this.getId()));
        return securePreferences;
    }

    private void handle(StorageException e) {
        if (!this.loggedStorageException) {
            this.loggedStorageException = true;
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.repositories.core", "Unexpected error accessing secure storage, falling back to in memory store for credentials. Some credentials may not be saved.", (Throwable)e));
        }
    }
}

