/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.oaametadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.oaametadata.Alias;
import org.eclipse.wst.jsdt.internal.oaametadata.Ancestor;
import org.eclipse.wst.jsdt.internal.oaametadata.Author;
import org.eclipse.wst.jsdt.internal.oaametadata.ClassData;
import org.eclipse.wst.jsdt.internal.oaametadata.DepreciatedOrAvailable;
import org.eclipse.wst.jsdt.internal.oaametadata.DocumentedElement;
import org.eclipse.wst.jsdt.internal.oaametadata.Enum;
import org.eclipse.wst.jsdt.internal.oaametadata.Event;
import org.eclipse.wst.jsdt.internal.oaametadata.Exception;
import org.eclipse.wst.jsdt.internal.oaametadata.IOAAMetaDataConstants;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;
import org.eclipse.wst.jsdt.internal.oaametadata.Method;
import org.eclipse.wst.jsdt.internal.oaametadata.Mix;
import org.eclipse.wst.jsdt.internal.oaametadata.Mixin;
import org.eclipse.wst.jsdt.internal.oaametadata.Namespace;
import org.eclipse.wst.jsdt.internal.oaametadata.Option;
import org.eclipse.wst.jsdt.internal.oaametadata.Parameter;
import org.eclipse.wst.jsdt.internal.oaametadata.Property;
import org.eclipse.wst.jsdt.internal.oaametadata.ReturnsData;
import org.eclipse.wst.jsdt.internal.oaametadata.VersionableElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataReader
extends DefaultHandler
implements IOAAMetaDataConstants {
    LibraryAPIs apis = new LibraryAPIs();
    Stack stack = new Stack();
    HashMap states = new HashMap();
    boolean collectText = false;
    boolean collectHTML = false;
    boolean pendingEndElement = false;
    boolean doTranslation = true;
    String collectTextElement;
    int currentState = 6;
    Object currentObject;
    StringBuffer text = new StringBuffer();
    HashMap collections;
    String filePath;
    HashMap messages = new HashMap();
    static final int STATE_ABOUTME = 1;
    static final int STATE_ALIAS = 2;
    static final int STATE_ALAISES = 3;
    static final int STATE_ANCESTOR = 4;
    static final int STATE_ANCESTORS = 5;
    static final int STATE_API = 6;
    static final int STATE_AUTHOR = 7;
    static final int STATE_AUTHORS = 8;
    static final int STATE_AVAILABLE = 9;
    static final int STATE_CONSTRUCTOR = 10;
    static final int STATE_CONSTRUCTORS = 11;
    static final int STATE_CLASS = 12;
    static final int STATE_CLASSES = 13;
    static final int STATE_DEPRECIATED = 14;
    static final int STATE_DESCRIPTION = 15;
    static final int STATE_ENUM = 16;
    static final int STATE_ENUMS = 17;
    static final int STATE_EVENT = 18;
    static final int STATE_EVENTS = 19;
    static final int STATE_EXAMPLE = 20;
    static final int STATE_EXAMPLES = 21;
    static final int STATE_EXCEPTION = 22;
    static final int STATE_EXCEPTIONS = 23;
    static final int STATE_FIELD = 24;
    static final int STATE_FIELDS = 25;
    static final int STATE_GLOBALS = 26;
    static final int STATE_INTERFACE = 27;
    static final int STATE_INTERFACES = 28;
    static final int STATE_LICENSE = 29;
    static final int STATE_METHOD = 30;
    static final int STATE_METHODS = 31;
    static final int STATE_MIX = 32;
    static final int STATE_MIXES = 33;
    static final int STATE_MIXIN = 34;
    static final int STATE_MIXINS = 35;
    static final int STATE_NAMESPACE = 36;
    static final int STATE_NAMESPACES = 37;
    static final int STATE_OPTION = 38;
    static final int STATE_OPTIONS = 39;
    static final int STATE_PARAMETER = 40;
    static final int STATE_PARAMETERS = 41;
    static final int STATE_PROPERTY = 42;
    static final int STATE_PROPERTIES = 43;
    static final int STATE_QOUTE = 44;
    static final int STATE_REMARKS = 45;
    static final int STATE_RETURNS = 46;
    static final int STATE_SEEALSO = 47;
    static final int STATE_TITLE = 48;
    static final int STATE_TOPIC = 49;
    static final int STATE_TOPICS = 50;
    static final int STATE_USERAGENT = 51;
    static final int STATE_USERAGENTS = 52;
    static final int STATE_INCLUDE = 53;
    static final ArrayList EMPTY_LIST = new ArrayList();
    private static final String EXTENSION = ".xml";
    private static final String ALL = "ALL";
    private static String[] nlSuffixes;

    public MetadataReader() {
        this.states.put("aboutMe", new Integer(1));
        this.states.put("api", new Integer(6));
        this.states.put("author", new Integer(7));
        this.states.put("available", new Integer(9));
        this.states.put("class", new Integer(12));
        this.states.put("classes", new Integer(13));
        this.states.put("enum", new Integer(16));
        this.states.put("enums", new Integer(17));
        this.states.put("example", new Integer(20));
        this.states.put("examples", new Integer(21));
        this.states.put("globals", new Integer(26));
        this.states.put("method", new Integer(30));
        this.states.put("property", new Integer(42));
        this.states.put("properties", new Integer(43));
        this.states.put("alias", new Integer(2));
        this.states.put("aliases", new Integer(3));
        this.states.put("ancestors", new Integer(5));
        this.states.put("ancestor", new Integer(4));
        this.states.put("authors", new Integer(8));
        this.states.put("author", new Integer(7));
        this.states.put("constructors", new Integer(11));
        this.states.put("constructor", new Integer(10));
        this.states.put("deprecated", new Integer(14));
        this.states.put("description", new Integer(15));
        this.states.put("enum", new Integer(16));
        this.states.put("event", new Integer(18));
        this.states.put("events", new Integer(19));
        this.states.put("example", new Integer(20));
        this.states.put("examples", new Integer(21));
        this.states.put("exception", new Integer(22));
        this.states.put("exceptions", new Integer(23));
        this.states.put("field", new Integer(24));
        this.states.put("fields", new Integer(25));
        this.states.put("interface", new Integer(27));
        this.states.put("interfaces", new Integer(28));
        this.states.put("license", new Integer(29));
        this.states.put("methods", new Integer(31));
        this.states.put("mix", new Integer(32));
        this.states.put("mixes", new Integer(33));
        this.states.put("mixin", new Integer(34));
        this.states.put("mixins", new Integer(35));
        this.states.put("namespace", new Integer(36));
        this.states.put("namespaces", new Integer(37));
        this.states.put("option", new Integer(38));
        this.states.put("options", new Integer(39));
        this.states.put("parameter", new Integer(40));
        this.states.put("parameters", new Integer(41));
        this.states.put("quote", new Integer(44));
        this.states.put("remarks", new Integer(45));
        this.states.put("returns", new Integer(46));
        this.states.put("seealso", new Integer(47));
        this.states.put("title", new Integer(48));
        this.states.put("topic", new Integer(49));
        this.states.put("topics", new Integer(50));
        this.states.put("useragent", new Integer(51));
        this.states.put("useragents", new Integer(52));
        this.states.put("include", new Integer(53));
    }

    public static LibraryAPIs readAPIsFromStream(InputSource inputSource, String path) {
        MetadataReader handler = new MetadataReader();
        handler.filePath = path;
        handler.loadMessageBundle();
        MetadataReader.parseMetadata(inputSource, handler);
        return handler.apis;
    }

    private static void parseMetadata(InputSource inputSource, MetadataReader handler) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            Util.log(e, "error reading oaametadata");
        }
        catch (IOException e) {
            Util.log(e, "error reading oaametadata");
        }
        catch (ParserConfigurationException e) {
            Util.log(e, "error reading oaametadata");
        }
    }

    public static LibraryAPIs readAPIsFromString(String metadata, String path) {
        return MetadataReader.readAPIsFromStream(new InputSource(new StringReader(metadata)), path);
    }

    public static LibraryAPIs readAPIsFromFile(String fileName) {
        try {
            FileInputStream file = new FileInputStream(fileName);
            LibraryAPIs apis = MetadataReader.readAPIsFromStream(new InputSource(file), fileName);
            apis.fileName = fileName.toCharArray();
            return apis;
        }
        catch (FileNotFoundException e) {
            Util.log(e, "error reading oaametadata");
            return null;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.collectText) {
            if (this.collectHTML && this.pendingEndElement) {
                this.text.append("/>");
                this.pendingEndElement = false;
            }
            this.text.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.collectText) {
            if ("http://openajax.org/metadata".equals(uri) && localName.equals(this.collectTextElement)) {
                switch (this.currentState) {
                    case 15: {
                        if (!(this.currentObject instanceof DocumentedElement)) break;
                        DocumentedElement documentedElement = (DocumentedElement)this.currentObject;
                        documentedElement.description = this.localizedString(this.text.toString());
                        documentedElement.isHTMLDescription = this.collectHTML;
                        break;
                    }
                    case 9: 
                    case 14: {
                        if (!(this.currentObject instanceof DepreciatedOrAvailable)) break;
                        ((DepreciatedOrAvailable)this.currentObject).text = this.localizedString(this.text.toString());
                        break;
                    }
                    case 1: 
                    case 44: {
                        if (!(this.currentObject instanceof Author)) break;
                        String text = this.localizedString(this.text.toString());
                        Author author = (Author)this.currentObject;
                        if (this.currentState == 1) {
                            author.aboutMe = text;
                            break;
                        }
                        author.quote = text;
                    }
                }
                this.popState();
                this.collectText = false;
                this.collectHTML = false;
                this.collectTextElement = null;
                this.text = new StringBuffer();
            } else if (this.pendingEndElement) {
                this.text.append("/>");
            } else {
                this.text.append("</").append(localName).append(">");
            }
            this.pendingEndElement = false;
        } else {
            switch (this.currentState) {
                case 6: {
                    ArrayList collection = this.getCollection("class");
                    this.apis.classes = collection.toArray(new ClassData[collection.size()]);
                    collection = this.getCollection("method");
                    this.apis.globalMethods = collection.toArray(new Method[collection.size()]);
                    collection = this.getCollection("property");
                    this.apis.globalVars = collection.toArray(new Property[collection.size()]);
                    collection = this.getCollection("author");
                    this.apis.authors = collection.toArray(new Author[collection.size()]);
                    collection = this.getCollection("enum");
                    this.apis.enums = collection.toArray(new Enum[collection.size()]);
                    collection = this.getCollection("alias");
                    this.apis.aliases = collection.toArray(new Alias[collection.size()]);
                    collection = this.getCollection("mixin");
                    this.apis.mixins = collection.toArray(new Mixin[collection.size()]);
                    collection = this.getCollection("namespace");
                    this.apis.namespaces = collection.toArray(new Namespace[collection.size()]);
                    break;
                }
                case 12: 
                case 27: {
                    ClassData clazz = (ClassData)this.currentObject;
                    ArrayList collection = this.getCollection("ancestor");
                    clazz.ancestors = collection.toArray(new Ancestor[collection.size()]);
                    collection = this.getCollection("constructor");
                    clazz.constructors = collection.toArray(new Method[collection.size()]);
                    collection = this.getCollection("event");
                    clazz.events = collection.toArray(new Event[collection.size()]);
                    collection = this.getCollection("property");
                    clazz.properties = collection.toArray(new Property[collection.size()]);
                    collection = this.getCollection("field");
                    clazz.fields = collection.toArray(new Property[collection.size()]);
                    collection = this.getCollection("method");
                    clazz.methods = collection.toArray(new Method[collection.size()]);
                    collection = this.getCollection("author");
                    clazz.mixins = collection.toArray(new Mix[collection.size()]);
                    collection = this.getCollection("alias");
                    clazz.aliases = collection.toArray(new Alias[collection.size()]);
                    break;
                }
                case 10: 
                case 30: {
                    Method method = (Method)this.currentObject;
                    ArrayList collection = this.getCollection("exception");
                    method.exceptions = collection.toArray(new Exception[collection.size()]);
                    collection = this.getCollection("parameter");
                    method.parameters = collection.toArray(new Parameter[collection.size()]);
                    break;
                }
                case 16: {
                    Enum enumData = (Enum)this.currentObject;
                    ArrayList collection = this.getCollection("option");
                    enumData.options = collection.toArray(new Option[collection.size()]);
                    break;
                }
                case 18: {
                    Event event = (Event)this.currentObject;
                    ArrayList collection = this.getCollection("parameter");
                    event.parameters = collection.toArray(new Parameter[collection.size()]);
                    break;
                }
                case 22: {
                    Exception exception = (Exception)this.currentObject;
                    ArrayList collection = this.getCollection("parameter");
                    exception.parameters = collection.toArray(new Parameter[collection.size()]);
                }
            }
            this.popState();
        }
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.collectText) {
            if (this.collectHTML) {
                this.text.append("<").append(localName);
                int nAttributes = attributes.getLength();
                int i = 0;
                while (i < nAttributes) {
                    String qname = attributes.getQName(i);
                    String value = attributes.getValue(i);
                    this.text.append(" ").append(qname).append("=\"").append(value).append("\"");
                    ++i;
                }
            }
            this.pendingEndElement = true;
        } else {
            Integer stateObj = null;
            this.pushState();
            if ("http://openajax.org/metadata".equals(uri) && (stateObj = (Integer)this.states.get(localName)) != null) {
                int state = stateObj;
                switch (state) {
                    case 1: {
                        this.startCollectingText(localName, attributes);
                        break;
                    }
                    case 2: {
                        Alias alias = new Alias();
                        this.currentObject = alias;
                        this.addCollectionElement("alias", alias);
                        alias.name = attributes.getValue("name");
                        alias.datatype = attributes.getValue("datatype");
                        break;
                    }
                    case 4: {
                        Ancestor ancestor = new Ancestor();
                        this.currentObject = ancestor;
                        this.addCollectionElement("ancestor", ancestor);
                        ancestor.dataType = attributes.getValue("datatype");
                        break;
                    }
                    case 6: {
                        this.apis.libraryVersion = attributes.getValue("version");
                        this.apis.language = attributes.getValue("language");
                        this.apis.getterPattern = attributes.getValue("getterPattern");
                        this.apis.setterPattern = attributes.getValue("setterPattern");
                        this.apis.setterPattern = attributes.getValue("setterPattern");
                        this.apis.spec = attributes.getValue("spec");
                        this.collections = new HashMap();
                        break;
                    }
                    case 7: {
                        Author author = new Author();
                        this.currentObject = author;
                        author.email = attributes.getValue("email");
                        author.location = attributes.getValue("location");
                        author.name = attributes.getValue("name");
                        author.organization = attributes.getValue("organization");
                        author.photo = attributes.getValue("photo");
                        author.type = attributes.getValue("type");
                        author.website = attributes.getValue("website");
                        this.addCollectionElement("author", author);
                        break;
                    }
                    case 9: {
                        DepreciatedOrAvailable available = new DepreciatedOrAvailable();
                        if (this.currentObject instanceof VersionableElement) {
                            ((VersionableElement)this.currentObject).available = available;
                        }
                        available.version = attributes.getValue("version");
                        this.startCollectingText(localName, attributes);
                        break;
                    }
                    case 12: 
                    case 27: {
                        ClassData clazz = new ClassData();
                        this.currentObject = clazz;
                        if (27 == state) {
                            clazz.isInterface = true;
                            this.addCollectionElement("interface", clazz);
                        } else {
                            this.addCollectionElement("class", clazz);
                        }
                        clazz.name = attributes.getValue("name");
                        clazz.superclass = attributes.getValue("superclass");
                        clazz.visibility = attributes.getValue("visibility");
                        clazz.getterPattern = attributes.getValue("getterPattern");
                        clazz.setterPattern = attributes.getValue("setterPattern");
                        this.collections = new HashMap();
                        break;
                    }
                    case 10: 
                    case 30: {
                        Method method = new Method();
                        if (10 == state) {
                            method.isContructor = true;
                            this.addCollectionElement("constructor", method);
                        } else {
                            this.addCollectionElement("method", method);
                        }
                        this.currentObject = method;
                        method.scope = attributes.getValue("scope");
                        method.visibility = attributes.getValue("visibility");
                        method.name = attributes.getValue("name");
                        this.collections = new HashMap();
                        break;
                    }
                    case 14: {
                        DepreciatedOrAvailable depreciated = new DepreciatedOrAvailable();
                        if (this.currentObject instanceof VersionableElement) {
                            ((VersionableElement)this.currentObject).depreciated = depreciated;
                        }
                        depreciated.isDepreciated = true;
                        depreciated.version = attributes.getValue("version");
                        this.startCollectingText(localName, attributes);
                        break;
                    }
                    case 15: {
                        this.startCollectingText(localName, attributes);
                        break;
                    }
                    case 16: {
                        Enum enumData = new Enum();
                        this.currentObject = enumData;
                        this.addCollectionElement("enum", enumData);
                        enumData.name = attributes.getValue("name");
                        enumData.datatype = attributes.getValue("datatype");
                        break;
                    }
                    case 18: {
                        Event event = new Event();
                        this.currentObject = event;
                        this.addCollectionElement("event", event);
                        this.collections = new HashMap();
                        break;
                    }
                    case 22: {
                        Exception exception = new Exception();
                        this.currentObject = exception;
                        this.addCollectionElement("exception", exception);
                        this.collections = new HashMap();
                        break;
                    }
                    case 24: 
                    case 42: {
                        Property property = new Property();
                        this.currentObject = property;
                        if (24 == state) {
                            property.isField = true;
                            this.addCollectionElement("field", property);
                        } else {
                            this.addCollectionElement("property", property);
                        }
                        property.name = attributes.getValue("name");
                        property.dataType = attributes.getValue("datatype");
                        property.scope = attributes.getValue("scope");
                        property.visibility = attributes.getValue("visibility");
                        this.collections = new HashMap();
                        break;
                    }
                    case 53: {
                        String src = attributes.getValue("src");
                        this.handleInclude(src);
                        break;
                    }
                    case 32: {
                        Mix mix = new Mix();
                        this.addCollectionElement("mix", mix);
                        this.currentObject = mix;
                        mix.datatype = attributes.getValue("datatype");
                        mix.fromScope = attributes.getValue("fromScope");
                        mix.toScope = attributes.getValue("toScope");
                        break;
                    }
                    case 34: {
                        Mixin mixin = new Mixin();
                        this.addCollectionElement("mixin", mixin);
                        this.currentObject = mixin;
                        mixin.name = attributes.getValue("name");
                        mixin.scope = attributes.getValue("scope");
                        mixin.visibility = attributes.getValue("visibility");
                        break;
                    }
                    case 36: {
                        Namespace namespace = new Namespace();
                        this.addCollectionElement("namespace", namespace);
                        this.currentObject = namespace;
                        namespace.name = attributes.getValue("name");
                        namespace.visibility = attributes.getValue("visibility");
                        break;
                    }
                    case 40: {
                        Parameter parameter = new Parameter();
                        this.currentObject = parameter;
                        this.addCollectionElement("parameter", parameter);
                        parameter.name = attributes.getValue("name");
                        parameter.dataType = attributes.getValue("datatype");
                        parameter.usage = attributes.getValue("usage");
                        this.collections = new HashMap();
                        break;
                    }
                    case 44: {
                        this.startCollectingText(localName, attributes);
                        break;
                    }
                    case 46: {
                        ReturnsData returnData = new ReturnsData();
                        if (this.currentObject instanceof Method) {
                            ((Method)this.currentObject).returns = returnData;
                        } else if (this.currentObject instanceof Event) {
                            ((Event)this.currentObject).returns = returnData;
                        } else if (this.currentObject instanceof Exception) {
                            ((Exception)this.currentObject).returns = returnData;
                        }
                        this.currentObject = returnData;
                        returnData.dataType = attributes.getValue("datatype");
                    }
                }
                this.currentState = state;
            }
        }
    }

    private void startCollectingText(String localName, Attributes attributes) {
        this.collectText = true;
        this.collectTextElement = localName;
        this.collectHTML = "text/html".equals(attributes.getValue("type"));
        this.text = new StringBuffer();
    }

    private void addCollectionElement(String tagClass, Object element) {
        ArrayList<Object> list;
        if (this.collections == null) {
            this.collections = new HashMap();
        }
        if ((list = (ArrayList<Object>)this.collections.get(tagClass)) == null) {
            list = new ArrayList<Object>();
            this.collections.put(tagClass, list);
        }
        list.add(element);
    }

    private ArrayList getCollection(String tagClass) {
        ArrayList list = null;
        if (this.collections != null) {
            list = (ArrayList)this.collections.get(tagClass);
        }
        if (list == null) {
            list = EMPTY_LIST;
        }
        return list;
    }

    private void popState() {
        StackElement stackElement = (StackElement)this.stack.pop();
        this.currentState = stackElement.state;
        this.collections = stackElement.collections;
        this.currentObject = stackElement.currentObject;
    }

    private void pushState() {
        StackElement newElement = new StackElement(this.currentState, this.currentObject, this.collections);
        this.stack.push(newElement);
    }

    private String localizedString(String string) {
        if (!this.doTranslation) {
            return string;
        }
        int subLength = "%%".length();
        int index = string.indexOf("%%");
        if (index < 0) {
            return string;
        }
        StringBuffer text = new StringBuffer();
        int start = 0;
        while (index >= 0) {
            text.append(string.substring(start, index));
            start = index + subLength;
            index = string.indexOf("%%", start);
            if (index < 0) {
                text.append(string.substring(start - subLength));
                break;
            }
            String key = string.substring(start, index);
            String value = (String)this.messages.get(key);
            String replace = value != null ? value : "%%" + key + "%%";
            text.append(replace);
            start = index + subLength;
            index = string.indexOf("%%", start);
        }
        return text.toString();
    }

    private void handleInclude(String src) {
        Path basePath = new Path(this.filePath);
        Path srcPath = new Path(src);
        basePath = basePath.removeLastSegments(1);
        basePath = basePath.append((IPath)srcPath);
        String fileName = basePath.toOSString();
        String savePath = this.filePath;
        try {
            FileInputStream file = new FileInputStream(fileName);
            this.filePath = fileName;
            MetadataReader.parseMetadata(new InputSource(file), this);
        }
        catch (FileNotFoundException e) {
            Util.log(e, "error reading oaametadata");
        }
        this.filePath = savePath;
    }

    private void loadMessageBundle() {
        String[] variants = MetadataReader.buildVariants();
        int i = 0;
        while (i < variants.length) {
            File file = new File(variants[i]);
            if (file.exists()) {
                try {
                    new InputSource(new FileReader(file));
                }
                catch (FileNotFoundException e) {
                    Util.log(e, "error reading oaametadata");
                }
            }
            ++i;
        }
    }

    private static String[] buildVariants() {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            String defaultStr = "";
            while (true) {
                result.add(String.valueOf(nl) + defaultStr + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                defaultStr = "_ALL";
                nl = nl.substring(0, lastSeparator);
            }
            result.add("ALL_ALL.xml");
            nlSuffixes = result.toArray(new String[result.size()]);
        }
        String[] variants = new String[nlSuffixes.length];
        int i = 0;
        while (i < variants.length) {
            variants[i] = nlSuffixes[i];
            ++i;
        }
        return variants;
    }

    static class StackElement {
        HashMap collections;
        Object currentObject;
        int state;

        StackElement(int st, Object obj, HashMap map) {
            this.collections = map;
            this.currentObject = obj;
            this.state = st;
        }
    }
}

