/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.TransientProperty;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.LocalizationUtil;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.internal.PropertyMetaModelServiceContext;
import org.eclipse.sapphire.util.ListFactory;

public abstract class PropertyDef
extends ModelMetadataItem {
    public static final String PROPERTY_FIELD_PREFIX = "PROP_";
    private final ElementType modelElementType;
    private final String propertyName;
    private final PropertyDef baseProperty;
    private final Class<?> typeClass;
    private final ElementType type;
    private List<Listener> listeners;
    private ServiceContext serviceContext;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PropertyDef(ElementType modelElementType, String propertyName, PropertyDef baseProperty) {
        this.modelElementType = modelElementType;
        this.propertyName = propertyName;
        this.baseProperty = baseProperty;
        try {
            Type typeAnnotation = this.getAnnotation(Type.class);
            if (typeAnnotation == null) {
                if (!(this instanceof ValueProperty)) {
                    String message = "Property \"" + propertyName + "\" of " + this.modelElementType.getModelElementClass().getClass() + " is missing the required Type annotation.";
                    throw new IllegalStateException(message);
                }
                this.typeClass = String.class;
            } else {
                this.typeClass = typeAnnotation.base();
            }
        }
        catch (RuntimeException e) {
            Sapphire.service(LoggingService.class).log(e);
            throw e;
        }
        if (!(this instanceof ValueProperty) && !(this instanceof TransientProperty)) {
            this.type = ElementType.read(this.typeClass);
            return;
        }
        this.type = null;
    }

    public ElementType getModelElementType() {
        return this.modelElementType;
    }

    public String name() {
        return this.propertyName;
    }

    public final Class<?> getTypeClass() {
        return this.typeClass;
    }

    public final ElementType getType() {
        return this.type;
    }

    public final boolean isOfType(Class<?> type) {
        return type.isAssignableFrom(this.getTypeClass());
    }

    @Override
    public PropertyDef getBase() {
        return this.baseProperty;
    }

    @Override
    protected void initAnnotations(ListFactory<Annotation> annotations) {
        Field propField = null;
        Field[] fieldArray = this.modelElementType.getModelElementClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propName;
            Field field = fieldArray[n2];
            String fieldName = field.getName();
            if (fieldName.startsWith(PROPERTY_FIELD_PREFIX) && this.propertyName.equalsIgnoreCase(propName = PropertyDef.convertFieldNameToPropertyName(fieldName))) {
                propField = field;
                break;
            }
            ++n2;
        }
        if (propField != null) {
            annotations.add((Annotation[])propField.getDeclaredAnnotations());
        }
    }

    @Override
    public <A extends Annotation> List<A> getAnnotations(Class<A> type) {
        ListFactory<A> annotationsListFactory = ListFactory.start();
        annotationsListFactory.add((Collection<A>)super.getAnnotations(type));
        if (this.baseProperty != null) {
            annotationsListFactory.add((Collection<A>)this.baseProperty.getAnnotations(type));
        }
        return annotationsListFactory.result();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> type) {
        A annotation = super.getAnnotation(type);
        if (annotation == null && this.baseProperty != null) {
            annotation = this.baseProperty.getAnnotation(type);
        }
        return annotation;
    }

    @Override
    protected final String getDefaultLabel() {
        return LocalizationUtil.transformCamelCaseToLabel(this.propertyName);
    }

    @Override
    public final LocalizationService getLocalizationService() {
        return this.modelElementType.getLocalizationService();
    }

    public final boolean isReadOnly() {
        return this.hasAnnotation(ReadOnly.class) || this.isDerived();
    }

    public final boolean isDerived() {
        return this.hasAnnotation(Derived.class);
    }

    protected RuntimeException convertReflectiveInvocationException(Exception e) {
        Throwable cause = e.getCause();
        if (cause instanceof EditFailedException) {
            return (EditFailedException)cause;
        }
        return new RuntimeException(e);
    }

    private static String convertFieldNameToPropertyName(String fieldName) {
        if (fieldName.startsWith(PROPERTY_FIELD_PREFIX)) {
            StringBuilder buffer = new StringBuilder();
            int i = PROPERTY_FIELD_PREFIX.length();
            while (i < fieldName.length()) {
                char ch = fieldName.charAt(i);
                if (ch != '_') {
                    buffer.append(ch);
                }
                ++i;
            }
            return buffer.toString();
        }
        return null;
    }

    public synchronized List<Listener> listeners() {
        if (this.listeners == null) {
            ListFactory<Listener> listenersListFactory = ListFactory.start();
            Listeners listenersAnnotation = this.getAnnotation(Listeners.class);
            if (listenersAnnotation != null) {
                Class<? extends Listener>[] classArray = listenersAnnotation.value();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<? extends Listener> cl = classArray[n2];
                    try {
                        listenersListFactory.add(cl.newInstance());
                    }
                    catch (Exception e) {
                        Sapphire.service(LoggingService.class).log(e);
                    }
                    ++n2;
                }
            }
            this.listeners = listenersListFactory.result();
        }
        return this.listeners;
    }

    public <S extends Service> S service(Class<S> type) {
        return this.services().service(type);
    }

    public <S extends Service> List<S> services(Class<S> type) {
        return this.services().services(type);
    }

    public synchronized ServiceContext services() {
        if (this.serviceContext == null) {
            this.serviceContext = new PropertyMetaModelServiceContext(this);
        }
        return this.serviceContext;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.modelElementType.getModelElementClass().getName());
        buf.append('#');
        buf.append(this.propertyName);
        return buf.toString();
    }
}

