/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.Set;
import java.util.SortedSet;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class ListFromValuePossibleValuesService
extends PossibleValuesService {
    private PossibleValuesService base;
    private Listener listener;
    private boolean broadcasting;

    @Override
    protected void init() {
        super.init();
        ListProperty listProperty = this.context(ListProperty.class);
        ValueProperty listMemberValueProperty = (ValueProperty)listProperty.getType().properties().first();
        this.base = listMemberValueProperty.service(PossibleValuesService.class);
        this.listener = new Listener(){

            @Override
            public void handle(Event event) {
                if (!ListFromValuePossibleValuesService.this.broadcasting) {
                    try {
                        ListFromValuePossibleValuesService.this.broadcasting = true;
                        ListFromValuePossibleValuesService.this.broadcast();
                    }
                    finally {
                        ListFromValuePossibleValuesService.this.broadcasting = false;
                    }
                }
            }
        };
        this.base.attach(this.listener);
    }

    @Override
    protected void fillPossibleValues(Set<String> values) {
        values.addAll(this.base.values());
    }

    @Override
    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return this.base.getInvalidValueSeverity(invalidValue);
    }

    @Override
    public String getInvalidValueMessage(String invalidValue) {
        return this.base.getInvalidValueMessage(invalidValue);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.base.isCaseSensitive();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.base.detach(this.listener);
            this.listener = null;
        }
        this.base = null;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            PropertyDef memberProperty;
            ElementType memberType;
            SortedSet<PropertyDef> properties;
            Property property = context.find(Property.class);
            return property != null && property.definition() instanceof ListProperty && property.service(PossibleTypesService.class).types().size() == 1 && (properties = (memberType = property.definition().getType()).properties()).size() == 1 && (memberProperty = properties.first()) instanceof ValueProperty && memberProperty.service(PossibleValuesService.class) != null;
        }
    }
}

