/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyVisitor;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.util.SetFactory;

public final class ModelBasedPossibleValuesService
extends PossibleValuesService {
    private ModelPath path;
    private String invalidValueMessageTemplate;
    private Status.Severity invalidValueSeverity;
    private boolean caseSensitive;
    private boolean ordered;
    private Set<String> values;
    private boolean initialized;
    private boolean readPriorToInit;

    @Override
    protected void init() {
        super.init();
        Property property = this.context(Property.class);
        final Element element = property.element();
        PossibleValues a = property.definition().getAnnotation(PossibleValues.class);
        this.path = new ModelPath(a.property());
        this.values = SetFactory.empty();
        this.invalidValueMessageTemplate = a.invalidValueMessage();
        this.invalidValueSeverity = a.invalidValueSeverity();
        this.caseSensitive = a.caseSensitive();
        this.ordered = a.ordered();
        final FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            @Override
            protected void handleTypedEvent(PropertyContentEvent event) {
                ModelBasedPossibleValuesService.this.refresh();
            }
        };
        element.attach((Listener)listener, this.path);
        this.refresh();
        element.attach(new FilteredListener<ElementDisposeEvent>(){

            @Override
            protected void handleTypedEvent(ElementDisposeEvent event) {
                element.detach(listener, ModelBasedPossibleValuesService.this.path);
            }
        });
        this.initialized = true;
    }

    @Override
    protected void fillPossibleValues(Set<String> values) {
        if (!this.initialized) {
            this.readPriorToInit = true;
        }
        values.addAll(this.values);
    }

    @Override
    public String getInvalidValueMessage(String invalidValue) {
        if (this.invalidValueMessageTemplate.length() > 0) {
            return MessageFormat.format(this.invalidValueMessageTemplate, invalidValue, this.context(PropertyDef.class).getLabel(true, CapitalizationType.NO_CAPS, false));
        }
        return super.getInvalidValueMessage(invalidValue);
    }

    @Override
    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return this.invalidValueSeverity;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean ordered() {
        return this.ordered;
    }

    private void refresh() {
        Element element = this.context(Element.class);
        if (!element.disposed()) {
            final SetFactory newValuesFactory = SetFactory.start();
            this.context(Element.class).visit(this.path, new PropertyVisitor(){

                @Override
                public boolean visit(Value<?> property) {
                    newValuesFactory.add(property.text());
                    return true;
                }
            });
            Set newValues = newValuesFactory.result();
            if (!this.values.equals(newValues)) {
                this.values = newValues;
                if (this.initialized || this.readPriorToInit) {
                    this.broadcast();
                }
            }
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            String path;
            PossibleValues possibleValuesAnnotation;
            Property property = context.find(Property.class);
            return (property instanceof Value || property instanceof ElementList) && (possibleValuesAnnotation = property.definition().getAnnotation(PossibleValues.class)) != null && (path = possibleValuesAnnotation.property()).length() > 0 && property.element().property(path) != null;
        }
    }
}

