/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.common.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivyde.common.completion.CodeCompletionProposal;
import org.apache.ivyde.common.model.IvyFile;
import org.apache.ivyde.common.model.IvyModel;
import org.apache.ivyde.common.model.IvyTag;
import org.apache.ivyde.common.model.IvyTagAttribute;
import org.apache.ivyde.common.model.Proposal;

public class IvyCodeCompletionProcessor {
    private String errorMessage = null;
    private final IvyModel model;

    public IvyCodeCompletionProcessor(IvyModel model) {
        this.model = model;
    }

    public CodeCompletionProposal[] computeCompletionProposals(IvyFile ivyfile, int caretOffset) {
        this.model.refreshIfNeeded(ivyfile);
        ArrayList propList = new ArrayList();
        if (ivyfile.inTag()) {
            String tagName = ivyfile.getTagName();
            if (ivyfile.readyForValue()) {
                this.computeValueProposals(tagName, ivyfile, propList, caretOffset);
            } else {
                this.computeTagAttributeProposals(tagName, ivyfile, propList, caretOffset);
            }
        } else {
            this.computeStructureProposals(ivyfile, propList, caretOffset);
        }
        return propList.toArray(new CodeCompletionProposal[propList.size()]);
    }

    private void computeTagAttributeProposals(String tagName, IvyFile ivyfile, List propList, int caretOffset) {
        String qualifier = ivyfile.getQualifier();
        int qlen = qualifier.length();
        if (qualifier.indexOf(47) > -1) {
            String text = "/>";
            CodeCompletionProposal proposal = new CodeCompletionProposal(text, ivyfile.getOffset() - qlen, qlen + caretOffset, text.length());
            propList.add(proposal);
        } else {
            String parent = ivyfile.getParentTagName();
            IvyTag tag = this.model.getIvyTag(tagName, parent);
            if (tag == null) {
                this.errorMessage = "tag :" + tagName + " not found in model:";
                return;
            }
            this.errorMessage = null;
            List atts = tag.getAttributes();
            Map existingAtts = ivyfile.getAllAttsValues();
            Iterator iter = atts.iterator();
            while (iter.hasNext()) {
                IvyTagAttribute att = (IvyTagAttribute)iter.next();
                if (!att.getName().startsWith(qualifier) || existingAtts.containsKey(att.getName())) continue;
                String text = String.valueOf(att.getName()) + "=\"\"";
                CodeCompletionProposal proposal = new CodeCompletionProposal(text, ivyfile.getOffset() - qlen, qlen + caretOffset, text.length() - 1, att.getName(), att.getDoc());
                propList.add(proposal);
            }
        }
    }

    private void computeValueProposals(String tagName, IvyFile ivyfile, List propList, int caretOffset) {
        Object[] values;
        IvyTag ivyTag;
        String parent = null;
        String tag = ivyfile.getTagName();
        if (tag != null) {
            parent = ivyfile.getParentTagName(ivyfile.getStringIndexBackward("<" + tag));
        }
        if ((ivyTag = this.model.getIvyTag(tag, parent)) != null && (values = ivyTag.getPossibleValuesForAttribute(ivyfile.getAttributeName(), ivyfile)) != null) {
            String qualifier = ivyfile.getAttributeValueQualifier();
            int qlen = qualifier == null ? 0 : qualifier.length();
            Arrays.sort(values);
            int i = 0;
            while (i < values.length) {
                Object val = values[i];
                CodeCompletionProposal proposal = null;
                String doc = ivyTag.getPossibleDocForValue((String)val, ivyfile);
                proposal = doc == null ? new CodeCompletionProposal((String)val, ivyfile.getOffset() - qlen, qlen + caretOffset, ((String)val).length()) : new CodeCompletionProposal((String)val, ivyfile.getOffset() - qlen, qlen + caretOffset, ((String)val).length(), (String)val, doc);
                propList.add(proposal);
                ++i;
            }
        }
    }

    private void computeStructureProposals(IvyFile ivyfile, List propList, int caretOffset) {
        String parent = ivyfile.getParentTagName();
        String qualifier = ivyfile.getQualifier();
        int qlen = qualifier.length();
        if (parent != null && ivyfile.getOffset() >= 2 + qualifier.length() && ivyfile.getString(ivyfile.getOffset() - 2 - qualifier.length(), ivyfile.getOffset()).startsWith("</")) {
            String text = "</" + parent + ">";
            CodeCompletionProposal proposal = new CodeCompletionProposal(text, ivyfile.getOffset() - qlen - 2, qlen + 2 + caretOffset, text.length());
            propList.add(proposal);
        } else {
            if (parent != null && qualifier.length() == 0) {
                String text = "</" + parent + ">";
                int closingIndex = ivyfile.getStringIndexForward(text);
                int openingIndex = ivyfile.getStringIndexForward("<" + parent);
                if (closingIndex == -1 || openingIndex != -1 && closingIndex > openingIndex) {
                    CodeCompletionProposal proposal = new CodeCompletionProposal(text, ivyfile.getOffset(), caretOffset, text.length());
                    propList.add(proposal);
                }
            }
            List childs = null;
            if (parent != null) {
                String parentParent = ivyfile.getParentTagName(ivyfile.getStringIndexBackward("<" + parent));
                IvyTag root = this.model.getIvyTag(parent, parentParent);
                if (root == null) {
                    this.errorMessage = "parent tag :" + parent + " not found in model:";
                    return;
                }
                childs = root.getChilds();
            } else {
                childs = Collections.singletonList(this.model.getRootIvyTag());
            }
            this.errorMessage = null;
            Iterator<IvyTag> iter = childs.iterator();
            while (iter.hasNext()) {
                IvyTag child = iter.next();
                if (!child.getStartTag().startsWith(qualifier)) continue;
                Proposal[] props = child.getProposals();
                int i = 0;
                while (i < props.length) {
                    propList.add(new CodeCompletionProposal(props[i].getProposal(), ivyfile.getOffset() - qlen, qlen + caretOffset, props[i].getCursor(), null, props[i].getDoc()));
                    ++i;
                }
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IvyModel getModel() {
        return this.model;
    }
}

